<?php

require_once "../modelos/conexion.php";
// Inicializar conexión
$conexion = Conexion::conectar();

// Captura los parámetros de la solicitud
$fechaInicial = isset($_POST['fechaInicial']) ? $_POST['fechaInicial'] : null;
$fechaFinal = isset($_POST['fechaFinal']) ? $_POST['fechaFinal'] : null;

// Recibir los parámetros de paginación
$start = isset($_POST['start']) ? (int)$_POST['start'] : 0;
$length = isset($_POST['length']) ? (int)$_POST['length'] : 10;
$draw = isset($_POST['draw']) ? intval($_POST['draw']) : 1;

// Recibir los parámetros de ordenamiento
$orderColumnIndex = isset($_POST['order'][0]['column']) ? intval($_POST['order'][0]['column']) : 0; // Índice de la columna
$orderDirection = isset($_POST['order'][0]['dir']) ? $_POST['order'][0]['dir'] : 'asc'; // Orden 'asc' o 'desc'

// Recibir el parámetro de búsqueda
$searchValue = isset($_POST['search']['value']) ? $_POST['search']['value'] : '';

// Mapeo de índices de columnas a nombres de columnas
$columns = [
    0 => 'p.id',  // Nro.
    1 => 'p.fecha', // Fecha
    2 => 'e.nombre', // Empresa
    3 => 'c.nombre', // Coordinador
    4 => 'p.nombre_pax', // Pax
    5 => 'p.importe_total', // Total
    6 => 'p.estado', // Estado
    7 => 'p.cerrado', // Cerrado
    8 => 'p.anulado', // Anulado
    9 => 'p.fecha_entrega', // Fecha Entrega
];

// Prepara la consulta para obtener el total de registros
$totalQuery = "SELECT COUNT(*) FROM pedidos p 
               INNER JOIN coordinadores c ON p.id_coordinador = c.id 
               INNER JOIN empresas e ON c.id_empresa = e.id 
               WHERE 1=1"; // Esta línea asegura que se pueda agregar condiciones fácilmente

// Añade condiciones según las fechas proporcionadas para el total
if ($fechaInicial && $fechaFinal) {
    $totalQuery .= " AND p.fecha >= :fechaInicial AND p.fecha <= :fechaFinal";
}

// Añadir condición de búsqueda
if ($searchValue) {
    $searchTerm = "%$searchValue%"; // Define el término de búsqueda con comodines
    $totalQuery .= " AND (";
    $searchConditions = [];

    // Generar condiciones para cada columna
    foreach ($columns as $index => $column) {
        // Evitar SQL Injection utilizando parámetros
        if ($index === 2) { // Empresa
            $searchConditions[] = "e.nombre LIKE :search";
        } elseif ($index === 3) { // Coordinador
            $searchConditions[] = "c.nombre LIKE :search";
        } else {
            $searchConditions[] = "$column LIKE :search"; // Otras columnas
        }
    }

    $totalQuery .= implode(' OR ', $searchConditions) . ")";
}

// Preparar la consulta para contar los registros
$totalStmt = $conexion->prepare($totalQuery);
if ($fechaInicial && $fechaFinal) {
    $totalStmt->bindParam(':fechaInicial', $fechaInicial);
    $totalStmt->bindParam(':fechaFinal', $fechaFinal);
}
if ($searchValue) {
    $totalStmt->bindParam(':search', $searchTerm);
}
$totalStmt->execute();
$totalData = $totalStmt->fetchColumn();

// Prepara la consulta para obtener los datos
$query = "
    SELECT 
        p.*, 
        c.nombre AS coordinador_nombre, 
        e.nombre AS empresa
    FROM 
        pedidos p 
    INNER JOIN 
        coordinadores c ON p.id_coordinador = c.id 
    INNER JOIN 
        empresas e ON c.id_empresa = e.id 
    WHERE 
        1=1"; // Esta línea asegura que se pueda agregar condiciones fácilmente

// Añade condiciones según las fechas proporcionadas
if ($fechaInicial && $fechaFinal) {
    $query .= " AND p.fecha >= :fechaInicial AND p.fecha <= :fechaFinal";
}

// Añadir condición de búsqueda
if ($searchValue) {
    $query .= " AND (";
    $searchConditions = [];

    // Generar condiciones para cada columna
    foreach ($columns as $index => $column) {
        // Evitar SQL Injection utilizando parámetros
        if ($index === 2) { // Empresa
            $searchConditions[] = "e.nombre LIKE :search";
        } elseif ($index === 3) { // Coordinador
            $searchConditions[] = "c.nombre LIKE :search";
        } else {
            $searchConditions[] = "$column LIKE :search"; // Otras columnas
        }
    }

    $query .= implode(' OR ', $searchConditions) . ")";
}

// Agrega la cláusula ORDER BY
if (isset($_POST['order']) && count($_POST['order']) > 0) {
    $query .= " ORDER BY " . $columns[$orderColumnIndex] . " " . $orderDirection;
} else {
    $query .= " ORDER BY p.id DESC"; // Ordenamiento por defecto
}

// Añadir límite para la paginación
$query .= " LIMIT :start, :length";

// Preparar la consulta
$stmt = $conexion->prepare($query);

// Asegúrate de que los parámetros sean correctos
if ($fechaInicial && $fechaFinal) {
    $stmt->bindParam(':fechaInicial', $fechaInicial);
    $stmt->bindParam(':fechaFinal', $fechaFinal);
}
if ($searchValue) {
    $stmt->bindParam(':search', $searchTerm);
}

// Pasar los parámetros de paginación a la consulta
$stmt->bindValue(':start', $start, PDO::PARAM_INT);
$stmt->bindValue(':length', $length, PDO::PARAM_INT);

// Ejecutar la consulta
$stmt->execute();
$pedidos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Modificar cada pedido para agregar el estado de cerrado y anulado
foreach ($pedidos as &$pedido) {
    // Comprobar el estado de cerrado
    if ($pedido['cerrado'] == 1) {
        $pedido['cerrado'] = "Cerrado";
    } else {
        $pedido['cerrado'] = "No Cerrado"; // Cambia este texto según tu preferencia
    }
    
    // Comprobar el estado de anulado
    if ($pedido['anulado'] == 1) {
        $pedido['anulado'] = "Anulado";
    } else {
        $pedido['anulado'] = "No Anulado"; // Cambia este texto según tu preferencia
    }
}

// Respuesta en formato DataTables
$response = [
    "draw" => $draw,
    "recordsTotal" => $totalData,
    "recordsFiltered" => $totalData, // Cambiar si hay filtros aplicados
    "data" => $pedidos
];

header('Content-Type: application/json');
echo json_encode($response);
