<?php
require __DIR__ . '/../vendor/autoload.php'; // Ajusta la ruta para incluir PHPMailer desde la carpeta raíz

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class ControladorCoordinadores
{

	/*=============================================
	CREAR COORDINADOR
	=============================================*/
	static public function ctrCrearCoordinador()
	{
		if (isset($_POST["nuevoCoordinador"])) {

			if (preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoCoordinador"])) {

				$tabla = "coordinadores";

				$datos = array(
					"nombre" => $_POST["nuevoCoordinador"],
					"documento" => $_POST["nuevoDocumentoId"],
					"hotel" => $_POST["seleccionarHotel"],
					"telefono" => $_POST["nuevoTelefono"],
					"empresa" => $_POST["seleccionarEmpresa"],
					"fecha_entrega" => $_POST["fechaEntrega"],
					"fecha_alta" => date("Y-m-d")
				);

				$respuesta = ModeloCoordinadores::mdlIngresarCoordinador($tabla, $datos);

				if ($respuesta) {
					echo '<script>
					  toastr.options = {
						"closeButton": true,
						"debug": true,
						"newestOnTop": false,
						"progressBar": true,
						"positionClass": "toast-top-right",
						"preventDuplicates": true,
						"showDuration": "300",
						"hideDuration": "1000",
						"timeOut": "3000",
						"extendedTimeOut": "1000",
						"showEasing": "swing",
						"hideEasing": "linear",
						"showMethod": "fadeIn",
						"hideMethod": "fadeOut"
					  };
					  toastr["success"]("Coordinador guardado correctamente.", "Listo!");
					  setTimeout(function() {
						  window.location = "coordinadores";
					  }, 1800);
					</script>';
				} else {
					echo '<script>
					  toastr.options = {
						"closeButton": true,
						"debug": true,
						"newestOnTop": false,
						"progressBar": true,
						"positionClass": "toast-top-right",
						"preventDuplicates": true,
						"showDuration": "300",
						"hideDuration": "1000",
						"timeOut": "5000",
						"extendedTimeOut": "1000",
						"showEasing": "swing",
						"hideEasing": "linear",
						"showMethod": "fadeIn",
						"hideMethod": "fadeOut"
					  }
					  toastr["error"]("Error al guardar Coordinador!", "Error!");
					  setTimeout(function() {
						window.location = "coordinadores";
					}, 1800);
					</script>';
				}
			} else {

				echo '<script>
              Swal.fire({
                  icon: "error",
                  title: "El nombre del Coordiador no puede contener caracteres especiales",
                  showConfirmButton: true,
                  confirmButtonText: "Cerrar"
              }).then(function(result){
                  if (result.isConfirmed) {
                      window.location = "coordinadores";
                  }
              });
          </script>';
			}
		}
	}

	/*=============================================
	MOSTRAR COORDINADORES
	=============================================*/

	static public function ctrMostrarCoordinadores($item, $valor)
	{

		$tabla = "coordinadores";

		$respuesta = ModeloCoordinadores::mdlMostrarCoordinadores($tabla, $item, $valor);

		return $respuesta;
	}

	/*=============================================
	EDITAR COORDINADOR
	=============================================*/
	static public function ctrEditarCoordinador()
	{

		if (isset($_POST["editarCliente"])) {

			if (preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarCliente"])) {

				$tabla = "coordinadores";

				$datos = array(
					"id" => $_POST["idCoordinador"],
					"nombre" => $_POST["editarCliente"],
					"documento" => $_POST["editarDocumentoId"],
					"hotel" => $_POST["seleccionarHotel"],
					"telefono" => $_POST["editarTelefono"],
					"empresa" => $_POST["seleccionarEmpresa"],
					"fecha_entrega" => $_POST["fechaEntrega"]
				);

				$respuesta = ModeloCoordinadores::mdlEditarCoordinador($tabla, $datos);

				if ($respuesta) {
					echo '<script>
					  toastr.options = {
						"closeButton": true,
						"debug": true,
						"newestOnTop": false,
						"progressBar": true,
						"positionClass": "toast-top-right",
						"preventDuplicates": true,
						"showDuration": "300",
						"hideDuration": "1000",
						"timeOut": "3000",
						"extendedTimeOut": "1000",
						"showEasing": "swing",
						"hideEasing": "linear",
						"showMethod": "fadeIn",
						"hideMethod": "fadeOut"
					  };
					  toastr["success"]("Coordinador modificado correctamente.", "Listo!");
					  setTimeout(function() {
						  window.location = "coordinadores";
					  }, 1800);
					</script>';
				} else {
					echo '<script>
					  toastr.options = {
						"closeButton": true,
						"debug": true,
						"newestOnTop": false,
						"progressBar": true,
						"positionClass": "toast-top-right",
						"preventDuplicates": true,
						"showDuration": "300",
						"hideDuration": "1000",
						"timeOut": "5000",
						"extendedTimeOut": "1000",
						"showEasing": "swing",
						"hideEasing": "linear",
						"showMethod": "fadeIn",
						"hideMethod": "fadeOut"
					  }
					  toastr["error"]("Error al modificar Coordinador!", "Error!");
					  setTimeout(function() {
						window.location = "coordinadores";
					}, 1800);
					</script>';
				}
			} else {

				echo '<script>
              Swal.fire({
                  icon: "error",
                  title: "El nombre del Coordiador no puede contener caracteres especiales",
                  showConfirmButton: true,
                  confirmButtonText: "Cerrar"
              }).then(function(result){
                  if (result.isConfirmed) {
                      window.location = "coordinadores";
                  }
              });
          </script>';
			}
		}
	}

	/*=============================================
  	CERRAR GRUPO
  	==============================================*/
	static public function ctrCerrarGrupo($coordinador = null)
	{
		if (isset($_POST["cerrarGrupo"]) || $coordinador != null) {

			$tabla = "coordinadores";
			$item = "id";
			$coordinador = ModeloCoordinadores::mdlMostrarCoordinadores($tabla, $item, $coordinador);

			$datos = array(
				"id_coordinador" => $coordinador["id"],
				"cerrado" => 1
			);

			$respuesta = ModeloCoordinadores::mdlCerrarGrupo($tabla, $datos);

			if ($respuesta) {
				echo '<script>
				  toastr.options = {
					"closeButton": true,
					"debug": true,
					"newestOnTop": false,
					"progressBar": true,
					"positionClass": "toast-top-right",
					"preventDuplicates": true,
					"showDuration": "300",
					"hideDuration": "1000",
					"timeOut": "3000",
					"extendedTimeOut": "1000",
					"showEasing": "swing",
					"hideEasing": "linear",
					"showMethod": "fadeIn",
					"hideMethod": "fadeOut"
				  };
				  toastr["success"]("Grupo cerrado correctamente.", "Listo!");
				  setTimeout(function() {
					  window.location = "pedidos-grupos";
				  }, 1000);
				</script>';
			} else {
				echo '<script>
				  toastr.options = {
					"closeButton": true,
					"debug": true,
					"newestOnTop": false,
					"progressBar": true,
					"positionClass": "toast-top-right",
					"preventDuplicates": true,
					"showDuration": "300",
					"hideDuration": "1000",
					"timeOut": "5000",
					"extendedTimeOut": "1000",
					"showEasing": "swing",
					"hideEasing": "linear",
					"showMethod": "fadeIn",
					"hideMethod": "fadeOut"
				  }
				  toastr["error"]("Error al cerrar Grupo!", "Error!");
				  setTimeout(function() {
					window.location = "pedidos-grupos";
				}, 1800);
				</script>';
			}
		}
	}

	/*=============================================
	ELIMINAR COORDINADOR
	=============================================*/
	static public function ctrEliminarCoordinador()
	{

		if (isset($_GET["idCoordinador"])) {

			$tabla = "clientes";
			$datos = $_GET["idCoordinador"];

			$respuesta = ModeloCoordinadores::mdlEliminarCliente($tabla, $datos);

			if ($respuesta == "ok") {

				echo '<script>

				swal({
					  type: "success",
					  title: "El cliente ha sido borrado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar",
					  closeOnConfirm: false
					  }).then(function(result){
								if (result.value) {

								window.location = "clientes";

								}
							})

				</script>';
			}
		}
	}

	function enviarCorreoConPDFsYHTML($coordinadorId)
	{
		$mail = new PHPMailer(true);

		try {
			// Configuración del servidor SMTP
			$mail->isSMTP();
			$mail->Host = 'smtp.gmail.com';
			$mail->SMTPAuth = true;
			$mail->Username = 'frantompedidos@gmail.com'; // Tu cuenta de Gmail
			$mail->Password = 'vpwh mcee qobj owsb'; // Contraseña de Gmail o clave de aplicación
			$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // TLS para puerto 587
			$mail->Port = 587;

			// Configuración del remitente y destinatario
			$mail->setFrom('frantompedidos@gmail.com', 'Reportes Frantom');

			// Puedes usar el $coordinadorId para determinar el destinatario
			//$destinatarioEmail = "frantomlogistica@gmail.com"; // Dirección del destinatario
			$destinatarioEmail = "yuri@richepatagonia.com";
			$mail->addAddress($destinatarioEmail, "Coordinador $coordinadorId");

			// Ruta del directorio que contiene los archivos
			$directory = __DIR__ . '/../reportes/' . $coordinadorId;

			if (is_dir($directory)) {
				// Adjuntar archivos PDF
				$pdfFiles = glob($directory . '/*.pdf');
				foreach ($pdfFiles as $pdf) {
					$mail->addAttachment($pdf); // Agregar cada archivo PDF como adjunto
				}

				// Adjuntar archivos HTML
				$htmlFiles = glob($directory . '/*.html');
				foreach ($htmlFiles as $html) {
					$mail->addAttachment($html); // Agregar cada archivo HTML como adjunto
				}
			} else {
				throw new Exception("El directorio $directory no existe.");
			}

			$respuestaCoordinador = self::ctrMostrarCoordinadores("id", $coordinadorId);

			$nombreCoordinador = $respuestaCoordinador["nombre"];
			$dniCoordinador = $respuestaCoordinador["documento"];
			$fechaEntrega = date('d/m/Y', strtotime($respuestaCoordinador["fecha_entrega"]));
			$empresa = $respuestaCoordinador["empresa"];

			// Contenido del correo
			$mail->isHTML(true);
			$mail->Subject = "Reportes del Coordinador $nombreCoordinador";
			$mail->isHTML(true);
			$mail->Subject = "Reportes del Coordinador $nombreCoordinador";
			$mail->Body = "
			<p>Se han generado los reportes correspondientes al coordinador:</p>
			<ul>
				<li><strong>Nombre:</strong> $nombreCoordinador</li>
				<li><strong>DNI:</strong> $dniCoordinador</li>
				<li><strong>Empresa:</strong> $empresa</li>
				<li><strong>Fecha de Entrega:</strong> $fechaEntrega</li>
			</ul>
			<p>A continuación, se adjuntan los siguientes archivos:</p>
			<ul>";
			// Enviar correo
			$mail->send();
			echo "El correo para el Coordinador $coordinadorId ha sido enviado exitosamente.";
		} catch (Exception $e) {
			echo "No se pudo enviar el correo para el Coordinador $coordinadorId.<br>";
			echo "Error de PHPMailer: {$mail->ErrorInfo}<br>";
			echo "Detalles de la excepción: {$e->getMessage()}<br>";
			echo "Archivo: {$e->getFile()}<br>";
			echo "Línea: {$e->getLine()}<br>";
		}
	}
}
