<?php
// Configurar la zona horaria de Argentina
date_default_timezone_set('America/Argentina/Buenos_Aires');
// Requerir la librería Dompdf
require_once 'autoload.inc.php';
require_once "../../modelos/conexion.php";
mb_internal_encoding("UTF-8");

use Dompdf\Dompdf;

// Crear una instancia de Dompdf
$dompdf = new Dompdf();

// Estilo del PDF
$html = '<html>
<head>
<style>
body {
    font-family: Arial, sans-serif;
    font-size: 12px;
}

h1 {
    text-align: center;
    margin-bottom: 20px;
}

table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 20px;
}

table th, table td {
    border: 1px solid #000;
    padding: 8px;
    text-align: left;
}

table th {
    background-color: #f5f5f5;
}

.summary {
    margin-top: 20px;
    text-align: center;
}
</style>
</head>
<body>
<h1>Grupos del Día</h1>
<table>
    <thead>
        <tr>
            <th>Nombre del Coordinador</th>
            <th>Empresa</th>
            <th>Fecha de Entrega</th>
            <th>Cantidad de Pedidos</th>
        </tr>
    </thead>
    <tbody>';

// Conexión a la base de datos
$conn = Conexion::obtenerConexion();
$conn->set_charset("utf8");

// Verificar la conexión
if ($conn->connect_error) {
    die('Error de conexión a la base de datos: ' . $conn->connect_error);
}

// Fecha actual
$fechaHoy = date('Y-m-d');

// Consulta para obtener la información de los coordinadores y sus pedidos
$sql = "SELECT coordinadores.nombre AS nombre_coordinador, coordinadores.fecha_entrega, COUNT(pedidos.id) AS cantidad_pedidos, empresas.nombre as nombre_empresa
        FROM pedidos
        LEFT JOIN coordinadores ON pedidos.id_coordinador = coordinadores.id
        LEFT JOIN empresas ON coordinadores.id_empresa = empresas.id
        WHERE pedidos.cerrado = 1 
        AND pedidos.anulado IS NULL 
        AND NOT pedidos.editando IS NULL
        AND DATE(pedidos.fecha) = '$fechaHoy'
        GROUP BY pedidos.id_coordinador, coordinadores.nombre, coordinadores.fecha_entrega
        ORDER BY coordinadores.fecha_entrega ASC";

$result = $conn->query($sql);

// Agregar los datos al HTML
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $html .= '<tr>
                    <td>' . $row['nombre_coordinador'] . '</td>
                    <td>' . $row['nombre_empresa'] . '</td>
                    <td>' . date('d/m/Y', strtotime($row['fecha_entrega'])) . '</td>
                    <td>' . $row['cantidad_pedidos'] . '</td>
                  </tr>';
    }
} else {
    $html .= '<tr>
                <td colspan="3" style="text-align:center;">No se encontraron grupos para el día de hoy.</td>
              </tr>';
}

$html .= '</tbody>
</table>
<p class="summary">Generado automáticamente el ' . date('d/m/Y') . '</p>
</body>
</html>';

// Cerrar conexión
$conn->close();

// Configurar el contenido HTML en Dompdf
$dompdf->loadHtml($html);

// Configurar el tamaño y orientación del papel
$dompdf->setPaper('A4', 'portrait');

// Renderizar el PDF
$dompdf->render();

// Nombre del archivo PDF
$filename = '../../reportes/grupos_del_dia.pdf';

// Guardar el archivo PDF en el servidor
file_put_contents($filename, $dompdf->output());

// Mostrar el PDF en el navegador
$dompdf->stream('grupos_del_dia.pdf', ['Attachment' => false]);

echo "PDF generado y guardado en: " . $filename;
?>
