<?php
// Requerir la librería Dompdf
require_once 'autoload.inc.php';
require_once "../../modelos/conexion.php";
mb_internal_encoding("UTF-8");

use Dompdf\Dompdf;

// Crear una instancia de Dompdf
$dompdf = new Dompdf();

// Generar el contenido HTML del PDF
$html = '<html>
<head>
<style>
.page {
    width: 100%;
    height: 100%;
    display: flex;
    flex-wrap: wrap;
    page-break-after: always;
}

.box {
    width: 50%;
    height: 50%;
    box-sizing: border-box;
    border: 1px solid #000;
    padding: 10px;
}

.invoice {
    margin-bottom: 10px;
    padding: 5px;
    background-color: #f5f5f5;
    font-size: 14px;
    height: 100%;
}

.invoice h2 {
    font-size: 14px;
    margin-top: 0;
}

.invoice p {
    margin: 3px 0;
}

table {
    width: 100%;
    border-collapse: collapse;
    font-size: 12px;
}

table th, table td {
    border: 1px solid #000;
    padding: 3px;
}

.company-info {
    float: left;
    margin-right: 20px;
}

.hotel-info {
    overflow: hidden;
}

.hotel-details {
    float: right;
}

.inline-p {
    display: inline;
    margin: 0;
    padding: 0;
    margin-right: 10px;
}

</style>
</head>
<body>
';

$conn = Conexion::obtenerConexion();
$conn->set_charset("utf8");

// Verificar la conexión
if ($conn->connect_error) {
    die('Error de conexión a la base de datos: ' . $conn->connect_error);
}

// Obtener el ID del coordinador deseado
$id_coordinador = Conexion::decryption($_GET["coordinador"]);

// Consulta para obtener los datos
$sql = 'SELECT pedidos.id AS id_pedido, pedidos.nro_pedido, pedidos.importe_pago, pedidos.importe_total, 
        pedidos.importe_debe, pedidos.fecha AS fecha_pedido, coordinadores.nombre AS coordinador_nombre,
        coordinadores.fecha_entrega as fecha_entrega, pedidos.nombre_pax, pedidos.nro_habitacion, 
        usuarios.nombre as nombre_vendedor, empresas.nombre AS empresa_nombre, hoteles.nombre AS hotel_nombre
        FROM pedidos
        LEFT JOIN coordinadores ON pedidos.id_coordinador = coordinadores.id
        LEFT JOIN empresas ON coordinadores.id_empresa = empresas.id
        LEFT JOIN hoteles ON coordinadores.id_hotel = hoteles.id
        LEFT JOIN usuarios ON usuarios.id = pedidos.id_vendedor
        WHERE pedidos.cerrado = 1 AND pedidos.anulado IS NULL 
        AND NOT pedidos.editando IS NULL AND coordinadores.id = ' . $id_coordinador;

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $invoices = [];

    // Obtener los datos de los invoices
    while ($row = $result->fetch_assoc()) {
        $invoices[] = $row;
    }

    // Generar páginas A4 con 4 invoices por página
    $totalInvoices = count($invoices);
    $invoicesPerPage = 4;

    for ($i = 0; $i < $totalInvoices; $i += $invoicesPerPage) {
        $html .= '<div class="page">';

        for ($j = $i; $j < $i + $invoicesPerPage && $j < $totalInvoices; $j++) {
            $invoice = $invoices[$j];

            $html .= '<div class="box">
                        <div class="invoice">
                            <h2>Pedido: ' . $invoice['nro_pedido'] . '</h2>
                            <p>Fecha Pedido: ' . date('d M Y', strtotime($invoice['fecha_pedido'])) . '</p>
                            <p>Empresa: ' . $invoice['empresa_nombre'] . '</p>
                            <p>Coordinador: ' . $invoice['coordinador_nombre'] . '</p>
                            <p>Hotel: ' . $invoice['hotel_nombre'] . '</p>
                            <p>Nombre Pax: ' . $invoice['nombre_pax'] . '</p>
                            <p>Habitación Nro: ' . $invoice['nro_habitacion'] . '</p>
                            <br>
                            <table>
                                <thead>
                                    <tr>
                                        <th style="text-align:center;">Cantidad</th>
                                        <th>Descripción</th>
                                        <th>Precio</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>';

            // Consulta para obtener los productos del pedido
            $itemsSql = 'SELECT pedidos_detalle.cantidad, productos.descripcion, productos.precio_venta
                         FROM pedidos_detalle
                         LEFT JOIN productos ON pedidos_detalle.id_producto = productos.id
                         WHERE pedidos_detalle.id_pedido = ' . $invoice['id_pedido'];
            $itemsResult = $conn->query($itemsSql);

            while ($itemRow = $itemsResult->fetch_assoc()) {
                $importe = number_format($itemRow['cantidad'] * $itemRow['precio_venta'], 2);

                $html .= '<tr>
                            <td style="text-align:center;">' . $itemRow['cantidad'] . '</td>
                            <td>' . strtoupper($itemRow['descripcion']) . '</td>
                            <td>' . number_format($itemRow['precio_venta'], 2) . '</td>
                            <td>' . $importe . '</td>
                          </tr>';
            }

            $html .= '</tbody>
                      </table>
                      </div>
                    </div>';
        }

        $html .= '</div>'; // Cerrar la página
    }
} else {
    echo 'No se encontraron notas de pedido.';
}

$html .= '</body></html>';
$conn->close();

// Guardar el HTML en un archivo
$htmlDir = '../../reportes';
if (!is_dir($htmlDir)) {
    mkdir($htmlDir, 0777, true);
}

$coordinadorHtmlDir = $htmlDir . '/' . $id_coordinador;
if (!is_dir($coordinadorHtmlDir)) {
    mkdir($coordinadorHtmlDir, 0777, true);
}

$htmlFile = $coordinadorHtmlDir . '/reporte_Notas_Pedido.html';
file_put_contents($htmlFile, $html);

// Cargar el contenido HTML en Dompdf
$dompdf->loadHtml($html);

// Configurar el tamaño y orientación del papel
$dompdf->setPaper('A4', 'portrait');

// Renderizar el PDF
$dompdf->render();

// Mostrar el PDF en el navegador
$dompdf->stream('reporte.pdf', ['Attachment' => false]);

echo "PDF y HTML generados y guardados en: " . $htmlFile . " y " . $pdfFile;
?>
