<?php
// Requerir la librería Dompdf
require_once 'autoload.inc.php';
require_once "../../modelos/conexion.php";
mb_internal_encoding("UTF-8");

use Dompdf\Dompdf;

// Crear una instancia de Dompdf
$dompdf = new Dompdf();

// Generar el contenido HTML del PDF
$html = '<html>
<head>
<style>
body {
    margin: 0;
    padding: 0;
    font-family: Arial, sans-serif;
}

.page {
    width: 100%;
    height: 100%;
    display: flex;
    flex-wrap: wrap;
}

.box {
    width: 50%;
    height: 50%;
    box-sizing: border-box;
    border: 1px solid #000;
    padding: 10px;
    margin: 0;
    page-break-inside: avoid;
    overflow: hidden;
}

.invoice {
    margin-bottom: 10px;
    padding: 5px;
    font-size: 14px;
    height: 100%;
}

.invoice h2 {
    font-size: 14px;
    margin-top: 0;
}

.invoice p {
    margin: 3px 0;
}

table {
    width: 100%;
    border-collapse: collapse;
    font-size: 10px; /* Ajuste inicial del tamaño de la fuente */
}

table th, table td {
    border: 1px solid #000;
    padding: 3px;
}

.company-info {
    margin-bottom: 5px;
}

.hotel-info {
    margin-bottom: 5px;
}

.hotel-details {
    float: right;
}

</style>
</head>
<body>
';

$conn = Conexion::obtenerConexion();
$conn->set_charset("utf8");
$duplicado = false; // Imprime por duplicado cada nota de pedido 

// Verificar la conexión
if ($conn->connect_error) {
    die('Error de conexión a la base de datos: ' . $conn->connect_error);
}

// Obtener el ID del coordinador deseado
$id_coordinador = Conexion::decryption($_GET["coordinador"]); // Reemplazar con el ID del coordinador deseado
// Consulta para obtener los invoices desde la tabla "pedidos"
$sql = 'SELECT pedidos.id AS id_pedido, pedidos.nro_pedido, pedidos.importe_pago, pedidos.importe_total, pedidos.importe_debe, pedidos.fecha AS fecha_pedido, coordinadores.nombre AS coordinador_nombre,
coordinadores.fecha_entrega as fecha_entrega, pedidos.fecha as fecha_pedido,pedidos.nombre_pax,
pedidos.nro_habitacion, usuarios.nombre as nombre_vendedor,
empresas.nombre AS empresa_nombre, hoteles.nombre AS hotel_nombre
        FROM pedidos
        LEFT JOIN coordinadores ON pedidos.id_coordinador = coordinadores.id
        LEFT JOIN empresas ON coordinadores.id_empresa = empresas.id
        LEFT JOIN hoteles ON coordinadores.id_hotel = hoteles.id
        LEFT JOIN usuarios ON usuarios.id = pedidos.id_vendedor
        WHERE pedidos.cerrado = 1 AND pedidos.anulado IS NULL AND NOT pedidos.editando is null AND coordinadores.id = ' . $id_coordinador;
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $invoices = array();

    // Obtener los datos de los invoices
    while ($row = $result->fetch_assoc()) {
        $invoice = array(
            'id' => $row['id_pedido'],
            'fecha_pedido' => date('d M Y', strtotime($row['fecha_pedido'])),
            'coordinator' => utf8_decode($row['coordinador_nombre']),
            'company' => utf8_decode($row['empresa_nombre']),
            'hotel' => utf8_decode($row['hotel_nombre']),
            'vendedor' => utf8_decode($row['nombre_vendedor']),
            'fecha_entrega' => date('d M Y', strtotime($row['fecha_entrega'])),
            'nombre_pax' => utf8_decode($row['nombre_pax']),
            'nro_habitacion' => utf8_decode($row['nro_habitacion']),
            'importe_pago' => $row['importe_pago'],
            'importe_total' => $row['importe_total'],
            'importe_debe' => $row['importe_debe'],
            'nro_pedido' => $row['nro_pedido'],
            'items' => array()
        );

        // Consulta para obtener los items del invoice desde las tablas "pedidos_detalle" y "productos"
        $itemsSql = 'SELECT pedidos_detalle.cantidad, productos.descripcion, productos.precio_venta
                     FROM pedidos_detalle
                     LEFT JOIN productos ON pedidos_detalle.id_producto = productos.id
                     WHERE pedidos_detalle.id_pedido = ' . $row['id_pedido'];
        $itemsResult = $conn->query($itemsSql);

        while ($itemRow = $itemsResult->fetch_assoc()) {
            $item = array(
                'quantity' => $itemRow['cantidad'],
                'description' => utf8_decode(strtoupper($itemRow['descripcion'])),
                'price' => $itemRow['precio_venta']
            );

            $invoice['items'][] = $item;
        }

        $invoices[] = $invoice;
    }

    // Configuración de la paginación
    $invoicesPerPage = 4;
    $totalInvoices = count($invoices);
    $totalPages = ceil($totalInvoices / $invoicesPerPage);

    for ($currentPage = 1; $currentPage <= $totalPages; $currentPage++) {
        // Añadir una nueva página
        $html .= '<div class="page">';

        $startIndex = ($currentPage - 1) * $invoicesPerPage;
        $endIndex = $startIndex + $invoicesPerPage;
        $pageInvoices = array_slice($invoices, $startIndex, $endIndex);

        foreach ($pageInvoices as $index => $invoice) {
            $html .= '<div class="box">'; // Comienza el recuadro para cada nota de pedido
            $html .= '<div class="invoice">';
            
            // Cabecera de la nota de pedido
            $html .= '<div class="company-info">
                        <p>Fecha Pedido: <strong>' . $invoice['fecha_pedido'] . '</strong></p>    
                        <p>Fecha Entrega: <strong>' . $invoice['fecha_entrega'] . '</strong></p>  
                        <p>Empresa: <strong>' . utf8_decode($invoice['company']) . '</strong></p>
                    </div>';
                    
            $html .= '<div class="hotel-info">
                        <div class="hotel-details">
                            <p>Hotel: <strong>' . utf8_decode($invoice['hotel']) . '</strong></p>
                            <p>Coordinador: <strong>' . utf8_decode($invoice['coordinator']) . '</strong></p>
                            <p>Pax: <strong>' . utf8_decode($invoice['nombre_pax']) . '</strong></p>
                            <p>Hab.: ' . $invoice['nro_habitacion'] . '</p>
                        </div>            
                    </div>';
                    
            // Tabla de productos
            $html .= '<table class="invoice-table">
                        <thead>
                            <tr>
                                <th>Cantidad</th>
                                <th>Descripción</th>
                            </tr>
                        </thead>
                        <tbody>';

            // Determinar el tamaño de la fuente dependiendo de la cantidad de productos
            $fontSize = (count($invoice['items']) > 10) ? 'font-size: 8px;' : 'font-size: 10px;'; // Reducir el tamaño de la fuente si hay muchos productos

            foreach ($invoice['items'] as $itemIndex => $item) {
                $html .= '<tr>
                            <td>' . $item['quantity'] . '</td>
                            <td>' . mb_convert_encoding(strtoupper($item['description']), 'UTF-8', 'ISO-8859-1') . '</td>
                          </tr>';
            }

            $html .= '</tbody>
                      </table>';
            
            $html .= '</div>'; // Cierre de .invoice
            $html .= '</div>'; // Cierre de .box
        }

        $html .= '</div>'; // Cierre de .page
    }

    // Cerrar el cuerpo del HTML
    $html .= '</body>
            </html>';

    echo $html;

    // Cargar el contenido HTML en Dompdf
    /*$dompdf->loadHtml($html);

    // (Opcional) Establecer el tamaño y la orientación del papel
    $dompdf->setPaper('A4', 'portrait');

    // Renderizar el PDF
    $dompdf->render();

    // Enviar el PDF al navegador para su descarga
    $dompdf->stream('invoices.pdf', ['Attachment' => false]);*/
} else {
    echo 'No se encontraron notas de pedido.';
}

// Cerrar la conexión a la base de datos
$conn->close();
?>
<script>
function printPage() {
  window.print();
}
</script>
