<?php
require('fpdf.php');

// Datos de la factura
$nombreCliente = "John Doe";
$direccionCliente = "Calle Principal, 123";
$fechaFactura = "2023-05-30";
$conceptos = array(
    array(
        "descripcion" => "Pedido numero 1",
        "precio" => 10.00,
        "cantidad" => 2
    ),
    array(
        "descripcion" => "Pedido numero 2",
        "precio" => 15.50,
        "cantidad" => 1
    ),
    array(
        "descripcion" => "Pedido numero 3",
        "precio" => 5.25,
        "cantidad" => 4
    ),
    array(
        "descripcion" => "Pedido numero 4",
        "precio" => 8.75,
        "cantidad" => 3
    )
);

// Crear el objeto PDF
$pdf = new FPDF('P', 'mm', 'A4');

// Configuración de fuente
$pdf->SetFont('Arial', 'B', 12);

// División de la factura en cuatro partes
$width = $pdf->GetPageWidth() / 2;
$height = $pdf->GetPageHeight() / 2;

// Configuración de auto salto de página
$pdf->SetAutoPageBreak(false);

// Tamaño A4
$pageWidth = 210; // Ancho en mm
$pageHeight = 297; // Alto en mm

// Página 1
$pdf->AddPage();
$pdf->SetXY(0, 0);
$pdf->Cell($pageWidth / 2, $pageHeight / 2, '', 1);

// Página 2
$pdf->SetXY($pageWidth / 2, 0);
$pdf->Cell($pageWidth / 2, $pageHeight / 2, '', 1);

// Página 3
$pdf->SetXY(0, $pageHeight / 2);
$pdf->Cell($pageWidth / 2, $pageHeight / 2, '', 1);

// Página 4
$pdf->SetXY($pageWidth / 2, $pageHeight / 2);
$pdf->Cell($pageWidth / 2, $pageHeight / 2, '', 1);

// Recorrer los productos y agregar el detalle en cada página
$pageCounter = 1; // Contador de páginas

foreach ($conceptos as $producto) {
    $descripcion = $producto['descripcion'];
    $precio = $producto['precio'];
    $cantidad = $producto['cantidad'];

    // Establecer la posición según la página actual
    switch ($pageCounter) {
        case 1:
            $pdf->SetXY(15, 5); // Ajustar la posición según tus necesidades
            break;
        case 2:
            $pdf->SetXY($pageWidth / 2 + 5, 5);
            break;
        case 3:
            $pdf->SetXY(5, $pageHeight / 2 + 5);
            break;
        case 4:
            $pdf->SetXY($pageWidth / 2 + 5, $pageHeight / 2 + 5);
            break;
    }

    // Agregar el detalle del producto en la página actual
    $pdf->Cell($width - 10, 10, "Producto: $descripcion");
    $pdf->Ln();
    $pdf->Cell($width - 10, 10, "Precio: $precio");
    $pdf->Ln();
    $pdf->Cell($width - 10, 10, "Cantidad: $cantidad");
    $pdf->Ln();

    // Incrementar el contador de páginas
    $pageCounter++;

    // Si se llega a la página 5, crear una nueva página
    if ($pageCounter > 4) {
        $pdf->AddPage();
        $pageCounter = 1;
    }
}

// Generar el archivo PDF
$pdf->Output('factura.pdf', 'F');

?>
