<?php 

require('fpdf.php');

function generarPedidosFicticios() {
    $pedidos = [];

    for ($i = 1; $i <= 8; $i++) {
        $nombreCliente = "Cliente $i";
        $direccionCliente = "Dirección $i";
        $fechaFactura = date('Y-m-d');
        $conceptos = [
            [
                "descripcion" => "Producto 1",
                "precio" => 10.00,
                "cantidad" => 2
            ],
            [
                "descripcion" => "Producto 2",
                "precio" => 15.50,
                "cantidad" => 1
            ],
            [
                "descripcion" => "Producto 3",
                "precio" => 5.25,
                "cantidad" => 4
            ],
            [
                "descripcion" => "Producto 4",
                "precio" => 8.75,
                "cantidad" => 3
            ]
        ];

        $pedido = [
            "nombreCliente" => $nombreCliente,
            "direccionCliente" => $direccionCliente,
            "fechaFactura" => $fechaFactura,
            "conceptos" => $conceptos
        ];

        $pedidos[] = $pedido;
    }

    return $pedidos;
}

// Obtener los pedidos ficticios
$pedidos = generarPedidosFicticios();

// Verificar si hay pedidos
if (count($pedidos) > 0) {
       // Crear el objeto PDF
$pdf = new FPDF('P', 'mm', 'A4');

// Configuración de fuente
$pdf->SetFont('Arial', 'B', 12);

// División de la hoja A4 en cuatro partes
$width = $pdf->GetPageWidth() / 2;
$height = $pdf->GetPageHeight() / 2;

// Configuración de auto salto de página
$pdf->SetAutoPageBreak(false);

// Tamaño A4
$pageWidth = 210; // Ancho en mm
$pageHeight = 297; // Alto en mm

// Recorrer los pedidos y agregar el detalle en cada página
$pageCounter = 1; // Contador de páginas

foreach ($pedidos as $pedido) {
    $nombreCliente = $pedido['nombreCliente'];
    $direccionCliente = $pedido['direccionCliente'];
    $fechaFactura = $pedido['fechaFactura'];
    $conceptos = $pedido['conceptos'];

    // Crear una nueva página cuando sea necesario
    if ($pageCounter > 4) {
        $pdf->AddPage();
        $pageCounter = 1;
    }

    // Establecer la posición según la página actual
    switch ($pageCounter) {
        case 1:
            $pdf->SetXY(5, 5); // Ajustar la posición según tus necesidades
            break;
        case 2:
            $pdf->SetXY($pageWidth / 2 + 5, 5);
            break;
        case 3:
            $pdf->SetXY(5, $pageHeight / 2 + 5);
            break;
        case 4:
            $pdf->SetXY($pageWidth / 2 + 5, $pageHeight / 2 + 5);
            break;
    }

    // Agregar el encabezado del pedido en la página actual
    $pdf->Cell($width - 10, 10, "Cliente: $nombreCliente");
    $pdf->Ln();
    $pdf->Cell($width - 10, 10, "Dirección: $direccionCliente");
    $pdf->Ln();
    $pdf->Cell($width - 10, 10, "Fecha: $fechaFactura");
    $pdf->Ln();

    // Agregar el detalle de los productos en la página actual
    foreach ($conceptos as $producto) {
        $descripcion = $producto['descripcion'];
        $precio = $producto['precio'];
        $cantidad = $producto['cantidad'];

        $pdf->Cell($width - 10, 10, "Producto: $descripcion");
        $pdf->Ln();
        $pdf->Cell($width - 10, 10, "Precio: $precio");
        $pdf->Ln();
        $pdf->Cell($width - 10, 10, "Cantidad: $cantidad");
        $pdf->Ln();
    }

    // Incrementar el contador de páginas
    $pageCounter++;
}

// Generar el archivo PDF
$pdf->Output('pedidos.pdf', 'F');
    // ...
} else {
    echo "No se encontraron pedidos disponibles.";
}


?>