<?php
require('fpdf.php');

class Invoice extends FPDF {
    function Header() {
        // No se muestra ninguna cabecera
    }

    function Footer() {
        // Configurar el pie de página del invoice
        $this->SetY(-15); // Posiciona 15 unidades desde el final de la página
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Página '.$this->PageNo().'/{nb}', 0, 0, 'C');
    }

    function generateInvoice($data, $x, $y, $width, $height) {
        // Generar el contenido del invoice
        $this->SetLineWidth(0.5);
        $this->Rect($x, $y, $width, $height); // Dibujar el recuadro del invoice

        $this->SetFont('Arial', '', 12);
        $this->SetXY($x + 5, $y + 5); // Posicionar el texto dentro del recuadro
        $this->Cell($width - 10, 10, 'Nota de Pedido '.$data['invoice_number'], 0, 1, 'C');
        // Agrega aquí los campos que deseas mostrar en el invoice
    }
}

// Conexión a la base de datos
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "ventas";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Consulta a la base de datos
$sql = "SELECT * FROM pedidos WHERE id_coordinador = 6";
$result = $conn->query($sql);

// Crear una instancia de la clase Invoice
$pdf = new Invoice();
$pdf->AliasNbPages(); // Necesario para el número total de páginas en el footer

// Dividir la página en 4 partes iguales
$sectionWidth = 105; // Ancho de cada sección (mitad de un A4 en modo horizontal)
$sectionHeight = 148; // Altura de cada sección (mitad de un A4 en modo vertical)

// Procesar los resultados de la consulta y generar los invoices
$i = 0;
while ($row = $result->fetch_assoc()) {
    // Verificar si se necesita una nueva página
    if ($i % 4 == 0 && $i > 0) {
        $pdf->AddPage('P', 'A4');
    }

    // Calcular las coordenadas de la sección actual
    $x = ($i % 2) * $sectionWidth;
    $y = (floor($i / 2) % 2) * $sectionHeight;

    // Mover la posición actual según la sección
    $pdf->SetXY($x, $y);

    // Obtener los datos del invoice
    $invoiceData = array(
        'invoice_number' => $row['id'], // Cambia esto según la estructura de tu base de datos
        // Agrega aquí los campos que deseas mostrar en el invoice
    );

    // Generar invoice en la sección actual
    $pdf->generateInvoice($invoiceData, $x, $y, $sectionWidth, $sectionHeight);

    $i++;
}

// Salida del PDF
$pdf->Output();
