<?php
require('fpdf.php');
require_once "../../modelos/conexion.php";

class PDF extends FPDF
{
    function Header()
    {
        global $nombre_empresa, $nombre_coordinador, $fecha_entrega, $nombre_hotel;

    }

    function Footer()
    {
        // Pie de página
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Pag. ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }
}

// Crear una instancia del objeto PDF
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->SetFont('Arial', '', 10);

// Obtener el ID del coordinador deseado
$id_coordinador = Conexion::decryption($_GET["coordinador"]);

// Establecer la conexión a la base de datos
$conn = Conexion::conectar();

// Consulta SQL para obtener los pedidos con los productos del coordinador especificado
$sql = "SELECT p.id AS id_pedido, p.codigo, p.fecha, c.nombre AS coordinador, pd.id_producto, pd.cantidad, pr.descripcion, pr.precio_venta, 
h.nombre as nombre_hotel, e.nombre as nombre_empresa, p.fecha_entrega, p.nro_habitacion, p.nombre_pax
        FROM pedidos p
        LEFT JOIN pedidos_detalle pd ON p.id = pd.id_pedido
        LEFT JOIN productos pr ON pd.id_producto = pr.id
        LEFT JOIN coordinadores c ON p.id_coordinador = c.id
        LEFT JOIN hoteles h ON c.id_hotel = h.id
        LEFT JOIN empresas e ON c.id_empresa = e.id
        WHERE p.id_coordinador = $id_coordinador and p.anulado IS NULL
        ORDER BY p.id";

// Ejecutar la consulta
$result = $conn->query($sql);

// Mostrar los pedidos en la grilla
$firstPage = true;
while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
    // Cambio de pedido, generar una nueva página
    if (!isset($id_pedido) || $id_pedido !== $row['id_pedido']) {

        // Inicializar los valores del nuevo pedido
        $id_pedido = $row['id_pedido'];

        // Generar una nueva página
        $pdf->AddPage();

        // Mostrar el título del reporte en la primera página
        if ($firstPage) {
            $pdf->SetFont('Arial', 'B', 20); // Cambiar el tamaño y estilo de la fuente
            $pdf->Cell(0, 20, 'Detalle de pedidos', 0, 1, 'C'); // Aumentar la altura de la celda
            $pdf->Ln(10);
            $firstPage = false;
        }

        // Mostrar los datos del pedido actual
        $pdf->SetFont('Arial', 'B', 14);
        $pdf->Cell(0, 10, 'Nro de Pedido: ' . $row['id_pedido'], 0, 1, 'L');
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(0, 10, 'Empresa: ' . utf8_decode($row['nombre_empresa']), 0, 1, 'L');
        $pdf->Cell(0, 10, 'Hotel: ' . utf8_decode($row['nombre_hotel']), 0, 1, 'L');
        $pdf->Cell(0, 10, 'Coordinador: ' . utf8_decode($row['coordinador']), 0, 1, 'L');
        $pdf->Cell(0, 10, 'Fecha Entrega: ' . date('d M Y', strtotime(utf8_decode($row['fecha_entrega']))), 0, 1, 'L');
        $pdf->SetFont('Arial', 'B', 10); 
        $pdf->Cell(0, 10, 'PAX y Hab.: ' . utf8_decode($row['nombre_pax']) . "  " . $row['nro_habitacion'], 0, 1, 'L');
        $pdf->Ln(5);

        // Encabezados de la grilla
        $pdf->SetFont('Arial', 'B', 12);
        $pdf->Cell(140, 10, 'Producto', 1, 0, 'C');
        $pdf->Cell(40, 10, 'Cantidad', 1, 1, 'C');
    }

    // Mostrar los detalles del pedido actual
    $pdf->SetFont('Arial', '', 12);
    $pdf->Cell(140, 10, utf8_decode($row['descripcion']), 1, 0, 'L');
    $pdf->Cell(40, 10, $row['cantidad'], 1, 1, 'C');
}

// Cerrar la conexión a la base de datos
$conn = null;

// Nombre del archivo PDF a guardar
$directory = '../../reportes/' . $id_coordinador;
if (!is_dir($directory)) {
    mkdir($directory, 0777, true);
}
$filename = $directory . '/reporte_Detalle_pedidos_.pdf';

// Guardar el PDF físicamente en el servidor
$pdf->Output('F', $filename);

// Salida para el navegador (opcional)
$pdf->Output('I', 'detalle_pedidos.pdf');

echo "PDF generado y guardado en: " . $filename;
?>
