<?php
header('Content-Type: text/html; charset=utf-8');

require('fpdf.php');
require_once "../../modelos/conexion.php";

// Guardar la configuración regional actual
$locale_original = setlocale(LC_TIME, 0);

// Establecer la configuración regional a español
setlocale(LC_TIME, 'es_ES');

// Establecer la conexión a la base de datos
$conn = Conexion::obtenerConexion();

if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

$idCoordinador = Conexion::decryption($_GET["coordinador"]);
// Realizar la consulta utilizando LEFT JOIN con pedidos, coordinadores y empresas
$query = "SELECT empresas.nombre AS nombre_empresa, pedidos.id AS numero_pedido, pedidos.nro_pedido, pedidos.nombre_pax AS pasajero, pedidos.nro_habitacion AS habitacion, coordinadores.fecha_entrega, coordinadores.telefono,
coordinadores.nombre as nombre_coordinador, coordinadores.fecha_entrega, pedidos.importe_total, ht.nombre as hotel FROM pedidos
LEFT JOIN coordinadores ON pedidos.id_coordinador = coordinadores.id
LEFT JOIN hoteles ht ON coordinadores.id_hotel = ht.id
LEFT JOIN empresas ON empresas.id = coordinadores.id_empresa WHERE pedidos.cerrado = 1 and not pedidos.editando is null AND pedidos.anulado IS NULL AND coordinadores.id = $idCoordinador";

$result = $conn->query($query);

// Obtener el nombre de la empresa
$empresa = "";
$coordinador = "";
$hotel = "";
$fecha_entrega = "";
if ($row = $result->fetch_assoc()) {
    $empresa = $row['nombre_empresa'];
    $coordinador = $row['nombre_coordinador'];
    $hotel = $row['hotel'];
    $fecha_entrega = $row['fecha_entrega'];
    $telefono = $row['telefono'];
}

// Cerrar la conexión a la base de datos
$conn->close();

// Crear una nueva instancia de la clase FPDF
$pdf = new FPDF();

// Agregar una página al PDF
$pdf->AddPage();

// Establecer la fuente y el tamaño para el título del PDF
$pdf->SetFont('Arial', 'B', 16);

// Agregar el título del PDF
$pdf->Cell(0, 10, 'Pedidos cobrados por Grupo', 0, 1, 'C');
$pdf->Ln(10);

// Establecer la fuente y el tamaño para el encabezado de la sección de empresa
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Hotel: ' . utf8_decode($hotel), 0, 1);

// Establecer la fuente y el tamaño para el encabezado de la sección de empresa
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Empresa: ' . $empresa, 0, 1);

// Establecer la fuente y el tamaño para el encabezado de la sección de coordinador
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Coordinador: ' . $coordinador, 0, 1);

// Establecer la fuente y el tamaño para el encabezado de la sección de coordinador
$pdf->SetFont('Arial', 'B', 12);
//$pdf->Cell(0, 10, 'Fecha Entrega: ' . strftime("%d %b %Y", strtotime($fecha_entrega)), 0, 1);
$pdf->Cell(0, 10, 'Fecha Entrega: ' . strftime("%d de %B de %Y", strtotime($fecha_entrega)), 0, 1);

// Establecer la fuente y el tamaño para el encabezado de la sección de coordinador
$pdf->SetFont('Arial', 'B', 12);
//$pdf->Cell(0, 10, 'Fecha Entrega: ' . strftime("%d %b %Y", strtotime($fecha_entrega)), 0, 1);
$pdf->Cell(0, 10, 'Telefono: ' . $telefono, 0, 1);

// Establecer la fuente y el tamaño para el encabezado de la tabla
$pdf->SetFont('Arial', 'B', 12);

// Agregar las cabeceras de la tabla con fondo negro
$pdf->SetFillColor(0, 0, 0);
$pdf->SetTextColor(255, 255, 255);
//$pdf->Cell(45, 10, 'Nro. Pedido', 1, 0, 'C', true);
$pdf->Cell(100, 10, 'Nombre PAX', 1, 0, 'C', true);
$pdf->Cell(90, 10, 'Nro. Hab.', 1, 0, 'C', true);

$pdf->Ln(); // Saltar a la siguiente línea

// Establecer la fuente y el tamaño para los datos de la tabla
$pdf->SetFont('Arial', '', 12);
$pdf->SetFillColor(255, 255, 255);
$pdf->SetTextColor(0, 0, 0);

// Contador de pedidos
$totalPedidos = 0;
$totalImporte = 0;

// Iterar sobre los resultados de la consulta y agregar los datos a la tabla
$result->data_seek(0); // Reiniciar el puntero del resultado a la posición inicial
while ($row = $result->fetch_assoc()) {
    //$pdf->Cell(45, 10, $row['nro_pedido'], 1, 0, 'C');
    $pdf->Cell(100, 10, utf8_decode($row['pasajero']), 1, 0, 'C');
    $pdf->Cell(90, 10, $row['habitacion'], 1, 0, 'C');
    $pdf->Ln(); // Saltar a la siguiente línea

    // Incrementar el contador de pedidos
    $totalPedidos++;

    // Sumar el importe total al totalizador de importes
    $totalImporte += $row['importe_total'];
}

// Agregar el total de pedidos debajo de la grilla
$pdf->Ln(10);
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Total de Pedidos: ' . $totalPedidos, 0, 1);


// Salida del PDF en otra pestaña
$pdf->Output('Pedidos cobrados por Grupo.pdf', 'I');
?>
