<?php
require('fpdf.php');
require_once "../../modelos/conexion.php";

class PDF extends FPDF
{
  private $fechaInicio;
  private $fechaFin;

  function setFechas($fechaInicio, $fechaFin) {
    $this->fechaInicio = $fechaInicio;
    $this->fechaFin = $fechaFin;
  }

  function Header()
  {
    global $nombre_empresa, $nombre_coordinador, $fecha_entrega, $nombre_hotel;

    // Título
    $this->SetFont('Arial', 'B', 16);
    $this->Cell(0, 20, 'Reporte de productos agrupados', 0, 1, 'C');

    $fechaInicioFormateada = date("d-m-Y", strtotime($this->fechaInicio));
    $fechaFinFormateada = date("d-m-Y", strtotime($this->fechaFin));

    // Agregar las fechas al título
    if ($this->fechaInicio && $this->fechaFin) {
      $this->SetFont('Arial', 'I', 12);
      $this->Cell(0, 10, 'Fecha desde ' . $fechaInicioFormateada . ' al ' . $fechaFinFormateada, 0, 1, 'C');
    }

    $this->Ln(10);
  }

  function Footer()
  {
    // Pie de página
    $this->SetY(-15);
    $this->SetFont('Arial', 'I', 8);
    $this->Cell(0, 10, 'Pag. ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
  }

  function generarReporte($data)
  {
    // Configuración de la página
    $this->AddPage();
    $this->SetFont('Arial', 'B', 10);

    // Encabezado de la tabla
    $this->SetFillColor(0, 0, 0); // Color de fondo negro
    $this->SetTextColor(255, 255, 255); // Color de texto blanco
    $this->Cell(120, 10, 'Producto', 1, 0, 'C', true); // Con fondo negro
    $this->Cell(60, 10, 'Cantidad', 1, 1, 'C', true); // Con fondo negro

    // Contenido de la tabla
    $this->SetFont('Arial', '', 10);
    $this->SetTextColor(0); // Restaurar color de texto negro
    $totalCantidad = 0; // Variable para almacenar la suma de las cantidades

    foreach ($data as $row) {
      $this->Cell(120, 10, strtoupper(utf8_decode($row['producto'])), 1, 0, 'L');
      $this->Cell(60, 10, $row['cantidad_total'], 1, 1, 'C');
      $totalCantidad += $row['cantidad_total']; // Sumar la cantidad actual al total
    }

    // Agregar el tfoot con la suma total de cantidades

    $this->Cell(120, 10, 'Total productos:', 1, 0, 'R', false); // Con fondo negro
    $this->Cell(60, 10, $totalCantidad, 1, 1, 'C', false); // Con fondo negro
  }
}

// Capturar fechas del formulario si están presentes
$fechaInicio = isset($_GET['fecha_inicio']) ? $_GET['fecha_inicio'] : null;
$fechaFin = isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : null;

// Crear una instancia del objeto PDF
$pdf = new PDF();
$pdf->setFechas($fechaInicio, $fechaFin); // Setear las fechas en el objeto PDF
$pdf->AliasNbPages();
$pdf->SetFont('Arial', '', 10);

// Obtener el ID del coordinador deseado
$id_coordinador = Conexion::decryption($_GET["coordinador"]); // Reemplazar con el ID del coordinador deseado

// Establecer la conexión a la base de datos
$conn = Conexion::conectar();

if ($conn) {
  // Consultar los datos de la base de datos
  $sql = "SET NAMES 'utf8'";
  $conn->query($sql);

  // Consultar los datos de la base de datos
  $sql = "SELECT pr.descripcion AS producto, SUM(pd.cantidad) AS cantidad_total, DATE_FORMAT(p.fecha, '%d/%m/%Y') AS fecha_pedido
  FROM pedidos p
  LEFT JOIN coordinadores c ON p.id_coordinador = c.id
  LEFT JOIN pedidos_detalle pd ON p.id = pd.id_pedido
  LEFT JOIN productos pr ON pd.id_producto = pr.id
  WHERE c.cerrado = 1 and p.cerrado = 1 and not p.editando is null";

  // Agregar condiciones de fecha si están presentes
  if ($fechaInicio && $fechaFin) {
    $sql .= " AND p.fecha BETWEEN '$fechaInicio' AND '$fechaFin'";
  }

  $sql .= " GROUP BY pr.id
  ORDER BY cantidad_total DESC, producto ASC";

  $result = $conn->query($sql);
  $data = array();

  foreach ($result as $key => $value) {
    $data[] = $value;
  }

  // Generar el reporte con los datos
  $pdf->generarReporte($data);

  // Salida del PDF
  $pdf->Output();

  // Cerrar la conexión a la base de datos
  Conexion::desconectar($conn);
} else {
  echo "Error de conexión a la base de datos.";
}
?>
