<?php

class Auditoria
{
    static public function escribirLog($mensaje)
    {
        $archivo = __DIR__ . "/auditoria.log";

        // Abre el archivo en modo escritura ("a" para agregar al final)
        $handler = fopen($archivo, "a");

        if ($handler) {
            // Agrega el mensaje y la información del usuario al archivo con la fecha y hora actual
            $usuario = isset($_SESSION['usuario']) ? $_SESSION['usuario'] : "Desconocido";
            $registro = "[" . date("Y-m-d H:i:s") . "] Usuario: " . $usuario . " - " . $mensaje . "\n";
            fwrite($handler, $registro);

            // Cierra el archivo
            fclose($handler);
        } else {
            // Manejar el error si no se puede abrir el archivo
            echo "Error al abrir el archivo de auditoría.";
        }
    }
}