<?php

require_once "conexion.php";
require_once "auditorias.class.php";

class ModeloCategorias
{

  /*=============================================
	CREAR CATEGORIA
	=============================================*/
  static public function mdlIngresarCategoria($tabla, $datos) {
    try {
        // Iniciar la transacción
        $link = Conexion::conectar();
        $link->beginTransaction();

        $stmt = $link->prepare("INSERT INTO $tabla(categoria) VALUES (:categoria)");
        $stmt->bindParam(":categoria", $datos, PDO::PARAM_STR);

        if ($stmt->execute()) {
            
            // Confirmar la transacción si todas las consultas fueron exitosas
            $link->commit();
            // Log de auditoría
            Auditoria::escribirLog("Se insertó una nueva categoría: " . $datos);
            return true;
        } else {
            // Cancelar la transacción en caso de error
            $link->rollBack();
            return false;
        }
    } catch (PDOException $e) {
        // Manejar cualquier excepción de la base de datos
        echo "Error: " . $e->getMessage();
    } finally {
        // Cerrar la conexión
        $link = null;
    }
  }


  /*=============================================
	MOSTRAR CATEGORIAS
	=============================================*/

  static public function mdlMostrarCategorias($tabla, $item, $valor)
  {
    $stmt = null;
    try {
      if ($item != null) {
        $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");
        $stmt->bindParam(":" . $item, $valor, PDO::PARAM_STR);
        $stmt->execute();
        return $stmt->fetch();
      } else {
        $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");
        $stmt->execute();
        return $stmt->fetchAll();
      }
    } catch (PDOException $e) {
      return "error: " . $e->getMessage();
    } finally {
      // Cerrar la conexión
      if ($stmt !== null) {
        $stmt->closeCursor();
      }
      $stmt = null;
    }
  }


  /*=============================================
	EDITAR CATEGORIA
	=============================================*/

  static public function mdlEditarCategoria($tabla, $datos)
  {
    try {
      $pdo = Conexion::conectar();
      $pdo->beginTransaction();

      $stmt = $pdo->prepare("UPDATE $tabla SET categoria = :categoria WHERE id = :id");

      $stmt->bindParam(":categoria", $datos["categoria"], PDO::PARAM_STR);
      $stmt->bindParam(":id", $datos["id"], PDO::PARAM_INT);

      if ($stmt->execute()) {
        // Log de auditoría
        Auditoria::escribirLog("Se editó la categoría con ID: " . $datos["id"]);
        $pdo->commit();
        return true;
      } else {
        $pdo->rollBack();
        return false;
      }
    } catch (PDOException $e) {
      return "error: " . $e->getMessage();
    }
  }


  /*=============================================
	BORRAR CATEGORIA
	=============================================*/
  static public function mdlBorrarCategoria($tabla, $datos)
  {
    try {
      $pdo = Conexion::conectar();
      $pdo->beginTransaction();

      $stmt = $pdo->prepare("DELETE FROM $tabla WHERE id = :id");

      $stmt->bindParam(":id", $datos, PDO::PARAM_INT);

      if ($stmt->execute()) {
        $pdo->commit();
        return "ok";
      } else {
        $pdo->rollBack();
        return "error";
      }
    } catch (PDOException $e) {
      return "error: " . $e->getMessage();
    } finally {
      // Cerrar la conexión
      $pdo = null;
    }
  }
}
