<?php

require_once "conexion.php";

class ModeloEmpresas
{

  /*=============================================
	CREAR EMPRESA
	=============================================*/
  static public function mdlIngresarEmpresa($tabla, $datos)
  {
    $conexion = Conexion::conectar();

    try {
      $conexion->beginTransaction();

      $stmt = $conexion->prepare("INSERT INTO $tabla(nombre) VALUES (:nombre)");

      $stmt->bindParam(":nombre", $datos, PDO::PARAM_STR);

      if ($stmt->execute()) {
        $conexion->commit();
        return true;
      } else {
        $conexion->rollback();
        // En caso de error, lanzamos una excepción personalizada con un mensaje
        throw new Exception("Error al insertar en la base de datos");
      }
    } catch (PDOException $e) {
      $conexion->rollback();
      // En caso de error de PDO, también lanzamos una excepción personalizada
      throw new Exception("Error de base de datos: " . $e->getMessage());
    } finally {
      // Finalmente, limpiamos los recursos
      $stmt = null;
      $conexion = null;
    }
  }

  /*=============================================
	MOSTRAR EMPRESAS
	=============================================*/
  static public function mdlMostrarEmpresas($tabla, $item, $valor)
  {

    if ($item != null) {

      $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

      $stmt->bindParam(":" . $item, $valor, PDO::PARAM_STR);

      $stmt->execute();

      return $stmt->fetch();
    } else {

      $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

      $stmt->execute();

      return $stmt->fetchAll();
    }

    $stmt = null;
  }

  /*=============================================
	EDITAR EMPRESA
	=============================================*/
  static public function mdlEditarEmpresa($tabla, $datos)
  {
    $conexion = Conexion::conectar();

    try {
      $conexion->beginTransaction();

      $stmt = $conexion->prepare("UPDATE $tabla SET nombre = :nombre WHERE id = :id");

      $stmt->bindParam(":nombre", $datos["nombre"], PDO::PARAM_STR);
      $stmt->bindParam(":id", $datos["id"], PDO::PARAM_INT);

      if ($stmt->execute()) {
        $conexion->commit();
        return true;
      } else {
        $conexion->rollback();
        return false;
      }
    } catch (PDOException $e) {
      $conexion->rollback();
      throw new Exception("Error de base de datos: " . $e->getMessage());
      echo "Error: " . $e->getMessage();
      return false;
    } finally {
      // Finalmente, limpiamos los recursos
      $stmt = null;
      $conexion = null;
    }
  }

  /*=============================================
	BORRAR EMPRESA
	=============================================*/

  static public function mdlBorrarEmpresa($tabla, $datos)
  {

    $stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE id = :id");

    $stmt->bindParam(":id", $datos, PDO::PARAM_INT);

    if ($stmt->execute()) {

      return true;
    } else {

      return false;
    }

    $stmt = null;
  }
}
