<?php

require_once "conexion.php";

class ModeloProductos
{

	/*=============================================
	MOSTRAR PRODUCTOS
	=============================================*/

	static public function mdlMostrarProductos($tabla, $item, $valor, $orden, $combos)
	{

		if ($item != null) {

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY id DESC");

			$stmt->bindParam(":" . $item, $valor, PDO::PARAM_STR);

			$stmt->execute();

			return $stmt->fetch();
		} else {

			if ($combos == null) {
				$stmt = Conexion::conectar()->prepare("SELECT *
				FROM $tabla
				ORDER BY CASE WHEN descripcion LIKE '%COMBO%' THEN 0 ELSE 1 END, descripcion ASC;");
				$stmt->execute();

				return $stmt->fetchAll();
			} else {
				$stmt = Conexion::conectar()->prepare("SELECT *
				FROM $tabla
				ORDER BY CASE WHEN descripcion LIKE '%COMBO%' THEN 0 ELSE 1 END, descripcion ASC;");
				$stmt->execute();

				return $stmt->fetchAll();
			}
		}

		$stmt = null;
	}

	/*=============================================
	REGISTRO DE PRODUCTO
	=============================================*/
	static public function mdlIngresarProducto($tabla, $datos)
	{
		$conexion = Conexion::conectar();
		$conexion->beginTransaction();
		try {
			$stmt = $conexion->prepare("INSERT INTO $tabla(id_categoria, codigo, descripcion, precio_venta) VALUES (:id_categoria, :codigo, :descripcion, :precio_venta)");

			$stmt->bindParam(":id_categoria", $datos["id_categoria"], PDO::PARAM_INT);
			$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_STR);
			$stmt->bindParam(":descripcion", $datos["descripcion"], PDO::PARAM_STR);
			$stmt->bindParam(":precio_venta", $datos["precio_venta"], PDO::PARAM_STR);

			if ($stmt->execute()) {
				$conexion->commit(); // Confirmar la transacción si la consulta se ejecuta correctamente
				return "ok";
			} else {
				$conexion->rollBack(); // Deshacer la transacción si la consulta falla
				return "error";
			}
		} catch (PDOException $e) {
			$conexion->rollBack(); // Deshacer la transacción en caso de excepción
			return "error";
		} finally {
			$stmt->closeCursor(); // Cerrar el cursor para liberar recursos
			$conexion->setAttribute(PDO::ATTR_AUTOCOMMIT, true); // Restaurar la configuración de confirmación automática de transacciones
			$conexion = null; // Cerrar la conexión
		}
	}


	/*=============================================
	EDITAR PRODUCTO
	=============================================*/
	static public function mdlEditarProducto($tabla, $datos)
	{
		$conexion = Conexion::conectar();
		$conexion->beginTransaction();
		try {
			$stmt = $conexion->prepare("UPDATE $tabla SET id_categoria = :id_categoria, codigo = :editarCodigo , descripcion = :descripcion, precio_venta = :precio_venta WHERE id = :id_producto");

			$stmt->bindParam(":id_categoria", $datos["id_categoria"], PDO::PARAM_INT);
			$stmt->bindParam(":id_producto", $datos["id_producto"], PDO::PARAM_INT);
			$stmt->bindParam(":editarCodigo", $datos["editarCodigo"], PDO::PARAM_STR);
			$stmt->bindParam(":descripcion", $datos["descripcion"], PDO::PARAM_STR);
			$stmt->bindParam(":precio_venta", $datos["precio_venta"], PDO::PARAM_STR);

			if ($stmt->execute()) {
				$conexion->commit(); // Confirmar la transacción si la consulta se ejecuta correctamente
				return true;
			} else {
				$conexion->rollBack(); // Deshacer la transacción si la consulta falla
				$errorInfo = $stmt->errorInfo();
				echo "Error al ejecutar la consulta: " . $errorInfo[2];
				return false;
			}
		} catch (PDOException $e) {
			$conexion->rollBack(); // Deshacer la transacción en caso de excepción
			return false;
		}
	}


	/*=============================================
	BORRAR PRODUCTO
	=============================================*/

	static public function mdlEliminarProducto($tabla, $datos)
	{
		$conexion = Conexion::conectar();
		$conexion->beginTransaction();
		try {
			$stmt = $conexion->prepare("DELETE FROM $tabla WHERE id = :id");

			$stmt->bindParam(":id", $datos, PDO::PARAM_INT);

			if ($stmt->execute()) {
				$conexion->commit(); // Confirmar la transacción si la consulta se ejecuta correctamente
				return "ok";
			} else {
				$conexion->rollBack(); // Deshacer la transacción si la consulta falla
				return "error";
			}
		} catch (PDOException $e) {
			$conexion->rollBack(); // Deshacer la transacción en caso de excepción
			return "error";
		} finally {
			$stmt->closeCursor(); // Cerrar el cursor para liberar recursos
			$conexion->setAttribute(PDO::ATTR_AUTOCOMMIT, true); // Restaurar la configuración de confirmación automática de transacciones
			$conexion = null; // Cerrar la conexión
		}
	}


	/*=============================================
	ACTUALIZAR PRODUCTO
	=============================================*/

	static public function mdlActualizarProducto($tabla, $item1, $valor1, $valor)
	{
		$conexion = Conexion::conectar();
		$conexion->beginTransaction();
		try {
			$stmt = $conexion->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id = :id");

			$stmt->bindParam(":" . $item1, $valor1, PDO::PARAM_STR);
			$stmt->bindParam(":id", $valor, PDO::PARAM_STR);

			if ($stmt->execute()) {
				$conexion->commit(); // Confirmar la transacción si la consulta se ejecuta correctamente
				return "ok";
			} else {
				$conexion->rollBack(); // Deshacer la transacción si la consulta falla
				return "error";
			}
		} catch (PDOException $e) {
			$conexion->rollBack(); // Deshacer la transacción en caso de excepción
			return "error";
		} finally {
			$stmt->closeCursor(); // Cerrar el cursor para liberar recursos
			$conexion->setAttribute(PDO::ATTR_AUTOCOMMIT, true); // Restaurar la configuración de confirmación automática de transacciones
			$conexion = null; // Cerrar la conexión
		}
	}


	/*=============================================
	MOSTRAR SUMA VENTAS
	=============================================*/

	static public function mdlMostrarSumaVentas($tabla)
	{

		$stmt = Conexion::conectar()->prepare("SELECT SUM(ventas) as total FROM $tabla");

		$stmt->execute();

		return $stmt->fetch();

		$stmt = null;
	}
}
