<?php 
date_default_timezone_set('America/Argentina/Buenos_Aires');
require_once "autoload.php";
require_once "../modelos/conexion.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Obtener el resultado de la consulta
$idCoordinador = Conexion::decryption($_GET["coordinador"]);
// Establecer la conexión a la base de datos
$conn = Conexion::obtenerConexion();
$query = "SELECT empresas.nombre AS nombre_empresa, pedidos.id AS numero_pedido, pedidos.nombre_pax AS pasajero, pedidos.nro_habitacion AS habitacion, coordinadores.fecha_entrega,
          coordinadores.nombre as nombre_coordinador, pedidos.importe_total FROM pedidos
          LEFT JOIN coordinadores ON pedidos.id_coordinador = coordinadores.id
          LEFT JOIN empresas ON empresas.id = coordinadores.id_empresa WHERE coordinadores.id = $idCoordinador AND pedidos.cerrado = 1";
$result = $conn->query($query);

// Crear un nuevo objeto Spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Obtener el primer resultado de la consulta para mostrar los datos generales
$row_data_general = $result->fetch_assoc();

// Mostrar los datos generales
$sheet->setCellValue('A1', 'Empresa:');
$sheet->setCellValue('B1', $row_data_general['nombre_empresa']);
$sheet->setCellValue('A2', 'Coordinador:');
$sheet->setCellValue('B2', $row_data_general['nombre_coordinador']);
$sheet->setCellValue('A3', 'Fecha de Entrega:');
$sheet->setCellValue('B3', $row_data_general['fecha_entrega']);

// Configurar el tamaño de las columnas de los datos generales
$sheet->getColumnDimension('A')->setWidth(15);
$sheet->getColumnDimension('B')->setWidth(30);

// Configurar los encabezados de las columnas
$sheet->setCellValue('A5', 'Nro. de Pedido');
$sheet->setCellValue('B5', 'Nombre PAX');
$sheet->setCellValue('C5', 'Nro. Habitación');
$sheet->setCellValue('D5', 'Importe Total');

// Configurar el tamaño de las columnas de la grilla
$sheet->getColumnDimension('A')->setWidth(15);
$sheet->getColumnDimension('B')->setWidth(20);
$sheet->getColumnDimension('C')->setWidth(20);
$sheet->getColumnDimension('D')->setWidth(15);

// Llenar el archivo Excel con los datos de la consulta
$row = 6; // Empezar desde la fila 6 para dejar espacio entre los datos generales y la grilla
$result->data_seek(0); // Reiniciar el puntero del resultado de la consulta

while ($row_data = $result->fetch_assoc()) {
    $sheet->setCellValue('A' . $row, $row_data['numero_pedido']);
    $sheet->setCellValue('B' . $row, $row_data['pasajero']);
    $sheet->setCellValue('C' . $row, $row_data['habitacion']);
    $sheet->setCellValue('D' . $row, $row_data['importe_total']);
    $row++;
}

// Guardar el archivo Excel
$fechaActual = date('Y-m-d');
$writer = new Xlsx($spreadsheet);
$filename = 'grupos_importes_'.date('d m Y', strtotime($fechaActual)).'.xlsx';
$writer->save($filename);

// Descargar el archivo Excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="' . $filename . '"');
header('Cache-Control: max-age=0');
$writer->save('php://output');

?>