<?php
date_default_timezone_set('America/Argentina/Buenos_Aires');
require "autoload.php";
require_once "../modelos/conexion.php";
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Obtener el ID del coordinador deseado
$id_coordinador = Conexion::decryption($_GET["coordinador"]); // Reemplaza con el ID del coordinador deseado

// Crear conexión a la base de datos
$conn = Conexion::obtenerConexion();

// Verificar la conexión
if ($conn->connect_error) {
    die('Error de conexión a la base de datos: ' . $conn->connect_error);
}

// Consulta SQL para obtener los pedidos con los productos del coordinador especificado
$sql = "SELECT e.nombre AS nombre_empresa, c.nombre AS nombre_coordinador, c.fecha_entrega AS fecha_entrega,
        pr.descripcion AS producto, SUM(pd.cantidad) AS cantidad_total, h.nombre AS nombre_hotel
        FROM pedidos p
        LEFT JOIN coordinadores c ON p.id_coordinador = c.id
        LEFT JOIN empresas e ON c.id_empresa = e.id
        LEFT JOIN hoteles h ON c.id_hotel = h.id
        LEFT JOIN pedidos_detalle pd ON p.id = pd.id_pedido
        LEFT JOIN productos pr ON pd.id_producto = pr.id
        WHERE c.id = $id_coordinador AND p.cerrado  = 1
        GROUP BY pr.id
        ORDER BY cantidad_total DESC, producto ASC";

// Ejecutar la consulta SQL
$result = $conn->query($sql);

// Crear un nuevo objeto Spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Obtener los datos únicos para las cabeceras destacadas
$row_data = $result->fetch_assoc();
$nombre_empresa = $row_data['nombre_empresa'];
$nombre_coordinador = $row_data['nombre_coordinador'];
$fecha_entrega = $row_data['fecha_entrega'];
$nombre_hotel = $row_data['nombre_hotel'];

// Agregar las cabeceras destacadas al principio del archivo Excel
$sheet->setCellValue('A1', 'Nombre Empresa:');
$sheet->setCellValue('B1', $nombre_empresa);
$sheet->setCellValue('A2', 'Nombre Coordinador:');
$sheet->setCellValue('B2', $nombre_coordinador);
$sheet->setCellValue('A3', 'Fecha Entrega:');
$sheet->setCellValue('B3', $fecha_entrega);
$sheet->setCellValue('A4', 'Nombre Hotel:');
$sheet->setCellValue('B4', $nombre_hotel);

// Agregar espacio entre las cabeceras destacadas y la grilla de productos y cantidades
$row = 6;

// Agregar la grilla de productos y cantidades
$sheet->setCellValue('A' . $row, 'Producto');
$sheet->setCellValue('B' . $row, 'Cantidad');

// Estilo para las celdas de Producto y Cantidad
$style = [
    'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF']],
    'fill' => ['fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID, 'startColor' => ['rgb' => '000000']]
];

// Aplicar el estilo a las celdas de Producto y Cantidad
$sheet->getStyle('A' . $row . ':B' . $row)->applyFromArray($style);

$row++;

// Iterar sobre los resultados de la consulta y escribir los datos en las celdas correspondientes
while ($row_data = $result->fetch_assoc()) {
    $sheet->setCellValue('A' . $row, $row_data['producto']);
    $sheet->setCellValue('B' . $row, $row_data['cantidad_total']);
    $row++;
}

// Establecer el ancho automático de las columnas
$sheet->getColumnDimension('A')->setAutoSize(true);
$sheet->getColumnDimension('B')->setAutoSize(true);

// Crear el objeto Writer para guardar el archivo Excel
$writer = new Xlsx($spreadsheet);

// Guardar el archivo Excel en el servidor
$filename = 'reporte.xlsx';
$writer->save($filename);

// Descargar el archivo Excel generado
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="' . $filename . '"');
header('Cache-Control: max-age=0');
readfile($filename);
unlink($filename); // Eliminar el archivo después de descargarlo

// Cerrar la conexión a la base de datos
$conn->close();
