/*=============================================
CARGAR LA TABLA DINÁMICA DE PEDIDOS
=============================================*/
var tablaVentas = $('.tablaVentas').DataTable({
  "ajax": "ajax/datatable-ventas.ajax.php",
  "deferRender": true,
  "retrieve": true,
  "processing": true,
  "pageLength": 3,
  "responsive": true,
  "search": {
    "regex": true
  },
  "ordering": false,
  "language": {
    "sProcessing": "Procesando...",
    "sLengthMenu": "Mostrar _MENU_ registros",
    "sZeroRecords": "No se encontraron resultados",
    "sEmptyTable": "Ningún dato disponible en esta tabla",
    "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
    "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
    "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
    "sInfoPostFix": "",
    "sSearch": "Buscar producto:",
    "sUrl": "",
    "sInfoThousands": ",",
    "sLoadingRecords": "Cargando...",
    "oPaginate": {
      "sFirst": "Primero",
      "sLast": "Último",
      "sNext": "Siguiente",
      "sPrevious": "Anterior"
    },
    "oAria": {
      "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
      "sSortDescending": ": Activar para ordenar la columna de manera descendente"
    }
  }
});


$('#miInputBusqueda').on('keyup', function () {
  var valorBusqueda = this.value.trim();
  // Verificar si hay una consulta de búsqueda o si el campo de búsqueda está vacío
  if (valorBusqueda !== '') {
    // Establecer un valor mayor para mostrar más resultados al realizar una búsqueda
    tablaVentas.page.len(10);
  } else {
    // Restablecer el valor inicial de pageLength si el campo de búsqueda está vacío
    tablaVentas.page.len(3);
  }
  tablaVentas.search(valorBusqueda, true, false).draw();
});


/*=============================================
AGREGANDO PRODUCTOS A LA VENTA DESDE LA TABLA
FUNCIÓN CUANDO DOY CLICK EN AGREGAR PRODUCTO
=============================================*/

$(".tablaVentas tbody").on("click", "button.agregarProducto", function () {

  // Restablecer el valor del campo de búsqueda a vacío
  $('#miInputBusqueda').val('');
  // Disparar el evento keyup para que se ejecute la lógica de búsqueda nuevamente
  $('#miInputBusqueda').trigger('keyup');

  var idProducto = $(this).attr("idProducto");

  $(this).removeClass("btn-primary agregarProducto");
  $(this).addClass("btn-default");

  var datos = new FormData();
  datos.append("idProducto", idProducto);

  $.ajax({
    url: "ajax/productos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function (respuesta) {
      var descripcion = respuesta["descripcion"].toUpperCase();
      var stock = respuesta["stock"];
      var precio = respuesta["precio_venta"];
      var cantidad;
      var totalParcial;

      var perfil = respuesta["perfil"];

      Swal.fire({
        title: "Ingrese cantidad",
        input: "number",
        inputValue: '',
        inputAttributes: {
          min: 1,
          inputmode: "numeric",
          pattern: "\\d*",
          step: 1,
          autofocus: true
        },
        showCancelButton: true,
        confirmButtonText: "Aceptar",
        cancelButtonText: "Cancelar",
        allowOutsideClick: false,
        inputValidator: (value) => {
          if (!value) {
            return "Debe ingresar una cantidad";
          }
        },
        customClass: {
          confirmButton: 'swal-custom-confirm-button',
          cancelButton: 'swal-custom-cancel-button',
        },
      }).then((result) => {
        if (result.isConfirmed) {
          var inputValue = result.value;
          this.cantidad = parseInt(inputValue, 10);
          if (isNaN(this.cantidad) || this.cantidad <= 0) {
            Swal.fire("Error", "La cantidad ingresada no es válida", "error");
            $("button.recuperarBoton[idProducto='" + idProducto + "']").removeClass('btn-default');
            $("button.recuperarBoton[idProducto='" + idProducto + "']").addClass('btn-primary agregarProducto');
            return;
          }
          // CANTIDAD POR PRECIO
          var totalParcial = parseFloat(this.cantidad * precio).toFixed(2);

          var inputDescuentoStyle = (respuesta["perfil"] === "Administrador" || respuesta["perfil"] === "Cajero") ? '' : 'style="display: none;"';

          $(".nuevoProducto").append(
            '<div class="row" style="padding:5px 15px">' +
            '<!-- Descripción del producto -->' +
            '<div class="col-lg-5 col-md-5 col-sm-6 col-xs-6">' +
            '<div class="input-group">' +
            '<span class="input-group-addon">' +
            '<button type="button" class="btn btn-danger btn-xs quitarProducto" idProducto="' + idProducto + '"><i class="fa fa-times"></i></button>' +
            '</span>' +
            '<input type="text" class="form-control nuevaDescripcionProducto" idProducto="' + idProducto + '" name="agregarProducto" value="' + descripcion + '" readonly required style="border-radius:5px !important;">' +
            '</div>' +
            '</div>' +

            '<!-- Cantidad del producto -->' +
            '<div class="col-lg-2 col-md-3 col-sm-3 col-xs-3">' +
            '<div class="input-group">' +
            '<input type="number" inputmode="numeric" min=1 oninput="validarEntero(this)" pattern="\d*" step="1" inputmode="numeric" class="form-control nuevaCantidadProducto" name="nuevaCantidadProducto" disabled min=1 value="' + this.cantidad + '" stock="' + stock + '" nuevoStock="' + Number(stock - 1) + '" required style="border-radius:5px !important;">' +
            '<div class="input-group-btn">' +
            '<button class="btn btn-default decrementButton" value="' + this.cantidad + '" type="button"><i class="fa fa-minus" aria-hidden="true"></i></button>' +
            '<button class="btn btn-default incrementButton" value="' + this.cantidad + '" type="button"><i class="fa fa-plus" aria-hidden="true"></i></button>' +
            '</div>' +
            '</div>' +
            '</div>' +

            '<!-- Precio del producto -->' +
            '<div class="col-lg-3 col-md-2 col-sm-3 col-xs-3 ingresoPrecio">' +
            '<div class="input-group" style="border-radius:5px;">' +
            '<span class="input-group-addon"><i class="ion ion-social-usd"></i></span>' +
            '<input type="text" id="nuevoPrecioProducto" class="form-control nuevoPrecioProducto" precioReal="' + precio + '" name="nuevoPrecioProducto" value="' + totalParcial + '" required style="border-radius:5px;" readonly>' +
            '</div>' +
            '</div>' +
            '<!-- Desc. del producto -->' +
            '<div class="col-lg-2 col-md-2 col-xs-6 ingresoDescuento" ' + inputDescuentoStyle + '>' +
            '<div class="input-group" style="border-radius:5px;">' +
            '<span class="input-group-addon"><i class="fa fa-percent"></i></span>' +
            '<input type="number" inputmode="numeric" class="form-control descuentoPorProducto" descuentoPorProducto name="descuentoPorProducto" min="0" step="0.1" style="border-radius:5px;" placeholder="% descuento individual">' +
            '</div>' +
            '</div>' +
            '</div>'
          );

          // SUMAR TOTAL DE PRECIOS
          sumarTotalPrecios();

          // AGREGAR IMPUESTO
          agregarDescuento();

          // AGRUPAR PRODUCTOS EN FORMATO JSON
          listarProductos();

          // PONER FORMATO AL PRECIO DE LOS PRODUCTOS
          $(".nuevoPrecioProducto").number(true, 2);

          localStorage.removeItem("quitarProducto");
        } else if (result.dismiss === Swal.DismissReason.cancel) {
          // El usuario hizo clic en "Cancelar"
          console.log("Se canceló el ingreso de cantidad");
          $("button.recuperarBoton[idProducto='" + idProducto + "']").removeClass('btn-default');
          $("button.recuperarBoton[idProducto='" + idProducto + "']").addClass('btn-primary agregarProducto');
        }
      });
    }
  });
});

/* ========================================
AGREGAR O QUITAR CANTIDADES
===========================================*/
$(".formularioVenta").on("click", ".incrementButton", function () {

  var inputCantidad = $(this).closest(".row").find("input.nuevaCantidadProducto");
  // Restringir el valor mínimo de cantidad a 1
  inputCantidad.attr("min", "1");
  var descuento = $(this).closest(".row").find("input.descuentoPorProducto");
  descuento.val(null);
  var valorActual = Number(inputCantidad.val());

  inputCantidad.val(valorActual + 1).trigger("change");

  agregarImportePago();

});

$(".formularioVenta").on("click", ".decrementButton", function () {
  var inputCantidad = $(this).closest(".row").find("input.nuevaCantidadProducto");
  // Restringir el valor mínimo de cantidad a 1
  inputCantidad.attr("min", "1");
  var descuento = $(this).closest(".row").find("input.descuentoPorProducto");
  var stock = Number(inputCantidad.attr("stock"));
  var valorActual = Number(inputCantidad.val());

  if (valorActual != 1) {
    inputCantidad.val(valorActual - 1).trigger("change");
  }

  descuento.val(null);
  agregarImportePago();

});

$("#nombrePax").on("click", function () {
  $(this).select();
});

$("#nroHabitacion").on("click", function () {
  $(this).select();
});

/*=============================================
MODIFICAR LA CANTIDAD
=============================================*/
$(".formularioVenta").on("change", "input.nuevaCantidadProducto", function () {

  var descuento = $(this).closest(".row").find("input.descuentoPorProducto");
  descuento.val(null);

  $(".nuevaCantidadProducto").on("click", function () {
    $(this).select();
  });

  var precio = $(this).parent().parent().parent().children(".ingresoPrecio").children().children(".nuevoPrecioProducto");

  var precioFinal = $(this).val() * precio.attr("precioReal");

  precio.val(parseFloat(precioFinal).toFixed(2));

  var nuevoStock = Number($(this).attr("stock")) - $(this).val();

  $(this).attr("nuevoStock", nuevoStock);

  if (Number($(this).val()) > Number($(this).attr("stock"))) {

    /*=============================================
    SI LA CANTIDAD ES SUPERIOR AL STOCK REGRESAR VALORES INICIALES
    =============================================*/

    $(this).val(0);

    $(this).attr("nuevoStock", $(this).attr("stock"));

    var precioFinal = $(this).val() * precio.attr("precioReal");

    precio.val(precioFinal);

    sumarTotalPrecios();

    swal({
      title: "La cantidad supera el Stock",
      text: "¡Sólo hay " + $(this).attr("stock") + " unidades!",
      type: "error",
      confirmButtonText: "¡Cerrar!"
    });

    return;

  }

  // SUMAR TOTAL DE PRECIOS

  sumarTotalPrecios();

  // AGREGAR IMPUESTO

  agregarDescuento();

  // AGRUPAR PRODUCTOS EN FORMATO JSON

  listarProductos();

});

/*=============================================
CUANDO CARGUE LA TABLA CADA VEZ QUE NAVEGUE EN ELLA
=============================================*/

$(".tablaVentas").on("draw.dt", function () {
  if (localStorage.getItem("quitarProducto") != null) {

    var listaIdProductos = JSON.parse(localStorage.getItem("quitarProducto"));

    for (var i = 0; i < listaIdProductos.length; i++) {

      $("button.recuperarBoton[idProducto='" + listaIdProductos[i]["idProducto"] + "']").removeClass('btn-default');
      $("button.recuperarBoton[idProducto='" + listaIdProductos[i]["idProducto"] + "']").addClass('btn-primary agregarProducto');
    }
  }
})


/*=============================================
QUITAR PRODUCTOS DE LA VENTA Y RECUPERAR BOTÓN
=============================================*/

var idQuitarProducto = [];

localStorage.removeItem("quitarProducto");

$(".formularioVenta").on("click", "button.quitarProducto", function () {

  $(this).parent().parent().parent().parent().remove();

  var idProducto = $(this).attr("idProducto");

  /*=============================================
  ALMACENAR EN EL LOCALSTORAGE EL ID DEL PRODUCTO A QUITAR
  =============================================*/

  if (localStorage.getItem("quitarProducto") == null) {

    idQuitarProducto = [];

  } else {

    idQuitarProducto.concat(localStorage.getItem("quitarProducto"))

  }

  idQuitarProducto.push({ "idProducto": idProducto });

  localStorage.setItem("quitarProducto", JSON.stringify(idQuitarProducto));

  $("button.recuperarBoton[idProducto='" + idProducto + "']").removeClass('btn-default');

  $("button.recuperarBoton[idProducto='" + idProducto + "']").addClass('btn-primary agregarProducto');

  if ($(".nuevoProducto").children().length == 0) {

    $("#nuevoTotalPago").val(0);
    $("#nuevoDescuento").val(0);
    $("#nuevoTotalVenta").val(0);
    $("#totalVenta").val(0);
    $("#nuevoTotalVenta").attr("total", 0);

  } else {

    // SUMAR TOTAL DE PRECIOS

    sumarTotalPrecios()

    // AGREGAR IMPUESTO

    agregarDescuento()

    // AGRUPAR PRODUCTOS EN FORMATO JSON

    listarProductos()

  }

})


/*=============================================
AGREGO DESCUENTO POR PRODUCTO
CUANDO HAGO CLICK EN CADA PRODUCTO SELECCIONADO
=============================================*/
$(".descuentoPorProducto").on("click", function () {
  $(this).select();
});
$(".formularioVenta").on("change", "input.descuentoPorProducto", function () {
  var descuento = $(this).val();
  var precio = $(this).parent().parent().parent().children(".ingresoPrecio").children().children(".nuevoPrecioProducto");
  var cantidad = $(this).parent().parent().parent().children().children().children(".nuevaCantidadProducto").val()
  var subtotal = (precio.attr("precioReal") * cantidad)

  var precioFinal = (subtotal) - (subtotal * descuento / 100);
  precio.val(parseFloat(precioFinal).toFixed(2));

  // SUMAR TOTAL DE PRECIOS
  sumarTotalPrecios()

  // AGREGAR IMPUESTO
  agregarDescuento()

  agregarPagoParcial();

  // AGRUPAR PRODUCTOS EN FORMATO JSON
  listarProductos()

})
/*=============================================
SUMAR TODOS LOS PRECIOS
=============================================*/

function sumarTotalPrecios() {

  var precioItem = $(".nuevoPrecioProducto");

  var arraySumaPrecio = [];

  for (var i = 0; i < precioItem.length; i++) {

    arraySumaPrecio.push(Number($(precioItem[i]).val()));


  }

  function sumaArrayPrecios(total, numero) {

    return total + numero;

  }

  /* VERIFICAR SI EXISTE UN DESCUENTO GENERAL APLICADO */
  var descuentoGeneral = $("#nuevoDescuento").val();
  var totalMasDescuento = arraySumaPrecio.reduce(sumaArrayPrecios);

  if (descuentoGeneral > 0) {
    var sumaTotalPrecio = totalMasDescuento - (totalMasDescuento * descuentoGeneral) / 100;
  } else {
    var sumaTotalPrecio = arraySumaPrecio.reduce(sumaArrayPrecios)
  }

  $("#nuevoTotalVenta").val(sumaTotalPrecio);
  $(".nuevoTotalPago").val(sumaTotalPrecio);
  $("#totalVenta").val(sumaTotalPrecio);
  $("#nuevoTotalVenta").attr("total", sumaTotalPrecio);
  $(".nuevoPrecioProducto").number(true, 2);

  $("#totalPedidoDiv").text(sumaTotalPrecio);
  $("#totalPedidoDiv").number(true, 2);

}


/*=============================================
SUMAR SUMA DE PRODUCTOS
=============================================*/

function sumarTotalPreciosProductos() {

  var precioItem = $(".nuevoPrecioProducto");

  var arraySumaPrecio = [];

  for (var i = 0; i < precioItem.length; i++) {
    arraySumaPrecio.push(Number($(precioItem[i]).val()));
  }

  function sumaArrayPrecios(total, numero) {
    return total + numero;
  }

  var sumaTotalPrecio = arraySumaPrecio.reduce(sumaArrayPrecios, 0); // Agregamos el valor inicial 0
  return sumaTotalPrecio;
}

/*=============================================
FUNCIÓN AGREGAR DESCUENTO GENERAL
=============================================*/
function agregarDescuento() {

  var precioTotal = sumarTotalPreciosProductos();
  $("#nuevoPrecioNeto").val(precioTotal);

  /*var descuento = $("#nuevoDescuento").val();
  var precioTotal = sumarTotalPreciosProductos();

  var precioImpuesto = Number(precioTotal * descuento / 100);

  var totalConDescuento = Number(precioTotal) - Number(precioImpuesto);

  $("#nuevoTotalVenta").val(totalConDescuento);

  $("#totalVenta").val(totalConDescuento);

  $("#nuevoPrecioImpuesto").val(precioImpuesto);

  // Importe total del pedido sin importar descuento
  $("#nuevoPrecioNeto").val(precioTotal);

  $(".nuevoTotalPago").val(totalConDescuento);*/

}

/*=============================================
FUNCIÓN AGREGAR IMPORTE DE PAGO PEDIDO
=============================================*/
function agregarImportePago() {
  var pago = $(".nuevoTotalPago").val();
  var precioTotal = $("#nuevoTotalVenta").val();
  var debe = Number(precioTotal - pago).toFixed(2);
  console.log("Pago: ", pago)
  console.log("Precio Total: ", precioTotal)
  console.log("Debe: ", debe)
  $("#nuevoTotalDebe").val(debe);
  $("#nuevoTotalDebe").number(true, 2);
}

$(".nuevoTotalPago").on("click", function () {
  $(this).select();
});

/*=============================================
CUANDO CAMBIA EL DESCUENTO
=============================================*/
$("#nuevoDescuento").on("click", function () {
  $(this).select();
});
$("#nuevoDescuento").change(function () {

  var descuento = $(this).val();

  var precioTotal = sumarTotalPreciosProductos();

  var precioImpuesto = Number(precioTotal * descuento / 100);

  var totalConDescuento = Number(precioTotal) - Number(precioImpuesto);

  // Comprobación 1: Asegurarse de que el descuento sea un número válido entre 0 y 100
  if (isNaN(descuento) || descuento < 0 || descuento > 100) {
    console.log("El descuento ingresado no es válido");
  }

  // Comprobación 2: Verificar si el total con descuento es menor o igual al precio total
  if (totalConDescuento > Number(precioTotal)) {
    console.log("El cálculo del descuento es incorrecto. El total con descuento es mayor que el precio total");
  }

  // Comprobación 3: Verificar si el precio del impuesto es correcto
  var impuestoEsperado = Number(precioTotal) - totalConDescuento;
  if (Math.abs(precioImpuesto - impuestoEsperado) > 0.01) {
    console.log("El cálculo del precio del impuesto es incorrecto");
  }

  // Comprobación 4: Verificar si el total con descuento y el precio del impuesto suman el precio total
  if (Math.abs(totalConDescuento + precioImpuesto - Number(precioTotal)) > 0.01) {
    console.log("La suma del total con descuento y el precio del impuesto no coincide con el precio total");
  }

  // Comprobación final: Imprimir el total con descuento
  console.log("Total con descuento: " + totalConDescuento);

  $("#nuevoTotalVenta").val(totalConDescuento);

  $(".nuevoTotalPago").val(totalConDescuento);

  $("#totalVenta").val(totalConDescuento);

  $("#nuevoPrecioNeto").val(precioTotal);

  /* CUANDO AGREGO UN DESCUENTO AL TOTAL SE ME RECALCULA LOS IMPORTES DE PAGO Y DEBE */
  $("#nuevoTotalDebe").val(totalConDescuento);
  agregarImportePago();

});

/*=============================================
AGREGAR EL MONTO PAGADO POR EL PEDIDO
=============================================*/
$(".nuevoTotalPago").change(function () {
  agregarImportePago();
});

$(".nuevoTotalPago").on('input', function () {
  // Lógica para agregar el importe del pago
  agregarImportePago();
});

/*=============================================
ASIGNAR EL VALOR TOTAL DEL PEDIDO AL PAGO PARCIAL
=============================================*/
function agregarPagoParcial() {
  // Obtener el valor inicial del input "nuevoTotalVenta"
  var valorInicial = parseFloat($("#nuevoTotalVenta").val());
  console.log("Valor inicial: ", valorInicial)
  // Asignar el nuevo valor al otro input
  $(".nuevoTotalPago").val(valorInicial);
}

/*=============================================
FORMATO AL PRECIO FINAL
=============================================*/
$(".nuevoPrecioProducto").number(true, 2);
$("#nuevoTotalVenta").number(true, 2);
$(".nuevoTotalPago").number(true, 2);
$("#nuevoPrecioProducto").number(true, 2);
$("#nuevoTotalDebe").number(true, 2);

/*=============================================
LISTAR TODOS LOS PRODUCTOS
=============================================*/

function listarProductos() {

  var listaProductos = [];

  var descripcion = $(".nuevaDescripcionProducto");

  var cantidad = $(".nuevaCantidadProducto");

  var precio = $(".nuevoPrecioProducto");

  var descuento = $(".descuentoPorProducto");

  for (var i = 0; i < descripcion.length; i++) {
    var descuentoValor = (typeof descuento[i] !== 'undefined') ? $(descuento[i]).val() : 0;
    listaProductos.push({
      "id": $(descripcion[i]).attr("idProducto"),
      "descripcion": $(descripcion[i]).val(),
      "cantidad": $(cantidad[i]).val(),
      "stock": $(cantidad[i]).attr("nuevoStock"),
      "precio": $(precio[i]).attr("precioReal"),
      "descuento": descuentoValor,
      "total": Number($(precio[i]).val()).toFixed(2)
    })

  }

  $("#listaProductos").val(JSON.stringify(listaProductos));

}

/*=============================================
BOTON EDITAR PEDIDO
=============================================*/
$(".tablas").on("click", ".btnEditarPedido", function () {
  var idPedido = $(this).attr("idPedido");
  var perfil = $(this).attr("perfil");
  window.location = "index.php?ruta=editar-pedido&idPedido=" + idPedido;
});

/*=============================================
BOTON EDITAR PEDIDO ADMIN
=============================================*/
$(".tablas").on("click", ".btnEditarPedidoAdmin", function () {
  var idPedido = $(this).attr("idPedido");
  var perfil = $(this).attr("perfil");
  window.location = "index.php?ruta=editar-pedido-admin&idPedido=" + idPedido;
});

// encriptado
$(document).ready(function () {
  $(document).on('click', '.btnVerPedido', function () {
    var idPedido = $(this).attr("IdPedido");
    console.log("id pedido::", idPedido)
    if (idPedido != '') {
      $.ajax({
        url: "vistas/modulos/detalle-pedido.php",
        method: "POST",
        data: { idPedido: idPedido },
        success: function (data) {
          $('#detalles').html(data);
          $('#dataModal').modal('show');
        }
      });
    }
  });
});

//sin encriptar
$(document).ready(function () {
  $(document).on('click', '.btnVerPedidoHistorial', function () {
    var idPedido = $(this).attr("IdPedido");
    if (idPedido != '') {
      $.ajax({
        url: "vistas/modulos/detalle-pedido-historial.php",
        method: "POST",
        data: { idPedido: idPedido },
        success: function (data) {
          $('#detalles').html(data);
          $('#dataModal').modal('show');
        }
      });
    }
  });
});

/*=============================================
FUNCIÓN PARA DESACTIVAR LOS BOTONES AGREGAR CUANDO EL PRODUCTO YA HABÍA SIDO SELECCIONADO EN LA CARPETA
=============================================*/

function quitarAgregarProducto() {

  //Capturamos todos los id de productos que fueron elegidos en la venta
  var idProductos = $(".quitarProducto");

  //Capturamos todos los botones de agregar que aparecen en la tabla
  var botonesTabla = $(".tablaVentas tbody button.agregarProducto");

  //Recorremos en un ciclo para obtener los diferentes idProductos que fueron agregados a la venta
  for (var i = 0; i < idProductos.length; i++) {

    //Capturamos los Id de los productos agregados a la venta
    var boton = $(idProductos[i]).attr("idProducto");

    //Hacemos un recorrido por la tabla que aparece para desactivar los botones de agregar
    for (var j = 0; j < botonesTabla.length; j++) {

      if ($(botonesTabla[j]).attr("idProducto") == boton) {

        $(botonesTabla[j]).removeClass("btn-primary agregarProducto");
        $(botonesTabla[j]).addClass("btn-default");

      }
    }

  }

}

/*=============================================
CADA VEZ QUE CARGUE LA TABLA CUANDO NAVEGAMOS EN ELLA EJECUTAR LA FUNCIÓN:
=============================================*/

$('.tablaVentas').on('draw.dt', function () {

  quitarAgregarProducto();

})


/*=============================================
BORRAR VENTA
=============================================*/
$(".tablas").on("click", ".btnEliminarVenta", function () {
  var idPedido = $(this).attr("idPedido");
  if (confirm("¿Está seguro de anular el pedido?\n¡Si no lo está puede cancelar la acción!")) {
    window.location = "index.php?ruta=pedidos&idPedido=" + idPedido;
  };
});

/*=============================================
ANULAR PEDIDO COBRADO
=============================================*/
$(".tablas").on("click", ".btnEliminarVentaYaCobrado", function () {
  var idPedido = $(this).attr("idPedido");
  if (confirm("¿Está seguro de anular el pedido ya cobrado?\n¡Si no lo está puede cancelar la acción!")) {
    window.location = "index.php?ruta=pedidos-cobrados&idPedido=" + idPedido;
  };
})


/* EXCEL */
$(".tablas").on("click", ".excelImportesPorGrupo", function () {
  var idCoordinador = $(this).attr("idCoordinador");
  window.open("vendor/importes_por_grupo.php?coordinador=" + idCoordinador, "_blank");
})

$(".tablas").on("click", ".excelProductosPorCoordinador", function () {
  var idCoordinador = $(this).attr("idCoordinador");
  window.open("vendor/productos_por_grupo.php?coordinador=" + idCoordinador, "_blank");
})

$(".tablas").on("click", ".excelProductosPedidos", function () {
  var idCoordinador = $(this).attr("idCoordinador");
  window.open("vendor/pedidos_importes.php?coordinador=" + idCoordinador, "_blank");
})

/*=============================================
IMPRIMIR FACTURA
=============================================*/
$(".tablas").on("click", ".btnImprimirFactura", function () {
  var codigoVenta = $(this).attr("codigoVenta");
  window.open("extensiones/tcpdf/pdf/factura.php?codigo=" + codigoVenta, "_blank");
});

/*=============================================
IMPRIMIR REPORTE PLANILLA
=============================================*/
$(".tablas").on("click", ".btnImprimirReporte", function () {

  var idCoordinador = $(this).attr("idCoordinador");
  window.open("extensiones/fpdf/reporte_importes.php?coordinador=" + idCoordinador, "_blank");

});

/*=============================================
IMPRIMIR REPORTE SIN IMPORTES POR GRUPO
=============================================*/
$(".tablas").on("click", ".btnImprimirReporteSinImporte", function () {

  var idCoordinador = $(this).attr("idCoordinador");
  window.open("extensiones/fpdf/reporte_importes_sin_importe.php?coordinador=" + idCoordinador, "_blank");

});

/*=============================================
IMPRIMIR REPORTE IMPORTES A COBRAR POR GRUPO
=============================================*/
$(".tablas").on("click", ".btnImprimirReporteAcobrar", function () {

  var idCoordinador = $(this).attr("idCoordinador");
  window.open("extensiones/fpdf/reporte_importes_a_cobrar.php?coordinador=" + idCoordinador, "_blank");

});

/*=============================================
IMPRIMIR PRODUCTOS AGRUPADOS POR COORDINADOR Y PEDIDO
=============================================*/
$(".tablas").on("click", ".btnImprimirReporteProductosAgrupados", function () {
  var idCoordinador = $(this).attr("idCoordinador");
  window.open("extensiones/fpdf/productos_por_grupo.php?coordinador=" + idCoordinador, "_blank");
});

/*=============================================
IMPRIMIR PRODUCTOS AGRUPADOS POR COORDINADOR Y PEDIDO DETALLE CON IMPORTES
=============================================*/
$(".tablas").on("click", ".btnImprimirReporteProductosDetalle", function () {
  var idCoordinador = $(this).attr("idCoordinador");
  window.open("extensiones/fpdf/productos_por_pedido.php?coordinador=" + idCoordinador, "_blank");
});

/*=============================================
IMPRIMIR PRODUCTOS AGRUPADOS POR COORDINADOR Y PEDIDO DETALLE SIN IMPORTES
=============================================*/

$(".tablas").on("click", ".btnImprimirReporteProductosDetalleSinImportes", function () {
  var idCoordinador = $(this).attr("idCoordinador");
  window.open("extensiones/fpdf/productos_por_pedido_v2.php?coordinador=" + idCoordinador, "_blank");
});

/*=============================================
IMPRIMIR NOTAS PEDIDO MASIVA POR COORDINADOR
=============================================*/

$(".tablas").on("click", ".btnImprimirNotasPedido", function () {
  var idCoordinador = $(this).attr("idCoordinador");
  //window.open("extensiones/dompdf/notas_pedido.php?coordinador=" + idCoordinador, "_blank");
  window.open("extensiones/dompdf/notas_pedido_duplicado.php?coordinador=" + idCoordinador, "_blank");
});

/*=============================================
IMPRIMIR NOTA PEDIDO INDIVIDUAL
=============================================*/

$(".tablas").on("click", ".btnImprimirNotaPedidoIndividual", function () {
  var idPedido = $(this).attr("idPedido");
  window.open("extensiones/dompdf/nota_individual.php?pedido=" + idPedido, "_blank");
});


/*=============================================
IMPRIMIR EXCEL
=============================================*/

$(".tablas").on("click", ".btnImprimirExcel", function () {

  var idPedido = $(this).attr("idPedido");
  window.open("vendor/reporte.php?idPedido=" + idPedido, "_blank");

});

/*=============================================
COBRAR PEDIDO
=============================================*/
$(".tablas").on("click", ".cobrarPedido", function () {
  var idPedido = $(this).attr("idPedido");
  var importeTotal = $(this).attr("importeTotal");
  if (confirm("¿Confirma cobrar el Pedido por un importe de $ " + importeTotal + "?\n¡Si no lo está puede cancelar la acción!")) {
    window.location = "index.php?ruta=cobrar-pedido&idPedido=" + idPedido;
  };
});

/*=============================================
CERAR GRUPO andando ok
=============================================*/
/*$(".tablas").on("click", ".cerrarGrupo", function () {
  var idCoordinador = $(this).attr("idCoordinador");
  if (confirm("¿Confirma cerrar el Grupo?\n¡Si no lo está puede cancelar la acción!")) {

    // Crear pdfs
    window.location = "index.php?ruta=cerrar-grupo&idCoordinador=" + idCoordinador;
  };
});*/

$(".tablas").on("click", ".cerrarGrupo", function () {
  var idCoordinador = $(this).attr("idCoordinador");

  if (confirm("¿Confirma cerrar el Grupo?\n¡Si no lo está puede cancelar la acción!")) {
    // Generar las URLs para las solicitudes
    var generarPDFUrl = "extensiones/fpdf/productos_por_grupoV1.php?coordinador=" + idCoordinador;
    var otroUrl = "extensiones/dompdf/notas_pedido_duplicadoV1.php?coordinador=" + idCoordinador;
    var otroPdf = "extensiones/fpdf/productos_por_pedido_v2.php?coordinador=" + idCoordinador;

    // Realizar ambas solicitudes en paralelo
    Promise.all([
      fetch(generarPDFUrl, { method: 'GET' }),
      fetch(otroUrl, { method: 'GET' }),
      fetch(otroPdf, { method: 'GET' })
    ])
    .then(() => {
      // Redirigir a la nueva página después de completar las solicitudes
      window.location = "index.php?ruta=cerrar-grupo&idCoordinador=" + idCoordinador;
    })
    .catch(error => {
      console.error('Error al generar los PDFs:', error);
      alert('Ocurrió un error al intentar generar los PDFs. Por favor, intente nuevamente.');
    });
  }
  
});

/*=============================================
RANGO DE FECHAS
=============================================*/
$('#daterange-btn').daterangepicker(
  {
    ranges: {
      'Hoy': [moment(), moment()],
      'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Últimos 7 días': [moment().subtract(6, 'days'), moment()],
      'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
      'Este mes': [moment().startOf('month'), moment().endOf('month')],
      'Último mes': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    },
    startDate: moment(),
    endDate: moment()
  },
  function (start, end) {
    $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));

    var fechaInicial = start.format('YYYY-MM-DD');

    var fechaFinal = end.format('YYYY-MM-DD');

    var capturarRango = $("#daterange-btn span").html();

    localStorage.setItem("capturarRango", capturarRango);

    window.location = "index.php?ruta=pedidos&fechaInicial=" + fechaInicial + "&fechaFinal=" + fechaFinal;

  }

)

/*=============================================
RANGO DE FECHAS PEDIDOS GRUPOS
=============================================*/

$('#daterange-btn-pedidos-grupos').daterangepicker(
  {
    ranges: {
      'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Últimos 7 días': [moment().subtract(6, 'days'), moment()],
      'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
      'Este mes': [moment().startOf('month'), moment().endOf('month')],
      'Último mes': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    },
    startDate: moment(),
    endDate: moment()
  },
  function (start, end) {
    $('#daterange-btn-pedidos-grupos span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));

    var fechaInicial = start.format('YYYY-MM-DD');

    var capturarRango = $("#daterange-btn-pedidos-grupos span").html();

    localStorage.setItem("capturarRango", capturarRango);

    window.location = "index.php?ruta=pedidos-grupos&fechaInicial=" + fechaInicial;

  }

);

$('#daterange-btn-pedidos-grupos-cerrados').daterangepicker(
  {
    ranges: {
      'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Últimos 7 días': [moment().subtract(6, 'days'), moment()],
      'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
      'Este mes': [moment().startOf('month'), moment().endOf('month')],
      'Último mes': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    },
    startDate: moment(),
    endDate: moment()
  },
  function (start, end) {
    $('#daterange-btn-pedidos-grupos-cerrados span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));

    var fechaInicial = start.format('YYYY-MM-DD');

    var capturarRango = $("#daterange-btn-pedidos-grupos span").html();

    localStorage.setItem("capturarRango", capturarRango);

    window.location = "index.php?ruta=grupos-cerrados&fechaInicial=" + fechaInicial;

  }

);

/*=============================================
RANGO DE FECHAS HISTORIAL DE PEDIDOS
=============================================*/
$('#daterange-btn-historial-pedidos').daterangepicker(
  {
    ranges: {
      'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Últimos 7 días': [moment().subtract(6, 'days'), moment()],
      'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
      'Este mes': [moment().startOf('month'), moment().endOf('month')],
      'Último mes': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    },
    startDate: moment(),
    endDate: moment()
  },
  function (start, end) {
    $('#daterange-btn-historial-pedidos span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));

    var fechaInicial = start.format('YYYY-MM-DD');

    var fechaFinal = end.format('YYYY-MM-DD');

    var capturarRango = $("#daterange-btn-historial-pedidos span").html();

    localStorage.setItem("capturarRango", capturarRango);

    window.location = "index.php?ruta=pedidos-historial&fechaInicial=" + fechaInicial + "&fechaFinal=" + fechaFinal;

  }

)

/*=============================================
RANGO DE FECHAS POR COORDINADOR
=============================================*/

$('#daterange-btn-coordinador').daterangepicker(
  {
    ranges: {
      'Hoy': [moment(), moment()],
      'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Últimos 7 días': [moment().subtract(6, 'days'), moment()],
      'Últimos 30 días': [moment().subtract(29, 'days'), moment()],
      'Este mes': [moment().startOf('month'), moment().endOf('month')],
      'Último mes': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    },
    startDate: moment(),
    endDate: moment()
  },
  function (start, end) {
    $('#daterange-btn-coordinador span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));

    var fechaInicial = start.format('YYYY-MM-DD');

    var fechaFinal = end.format('YYYY-MM-DD');

    var capturarRango = $("#daterange-btn-coordinador span").html();

    localStorage.setItem("capturarRango", capturarRango);

    window.location = "index.php?ruta=pedidos-coordinador&fechaInicial=" + fechaInicial + "&fechaFinal=" + fechaFinal;

  }

)

/*=============================================
CANCELAR RANGO DE FECHAS
=============================================*/

$(".daterangepicker.opensleft .range_inputs .cancelBtn").on("click", function () {

  localStorage.removeItem("capturarRango");
  localStorage.clear();
  window.location = "ventas";
})

/*=============================================
CAPTURAR HOY
=============================================*/

$(".daterangepicker.opensleft .ranges li").on("click", function () {

  var textoHoy = $(this).attr("data-range-key");
  var url = $(this).attr("url");

  if (textoHoy == "Hoy") {

    var d = new Date();

    var dia = d.getDate();
    var mes = d.getMonth() + 1;
    var año = d.getFullYear();

    dia = ("0" + dia).slice(-2);
    mes = ("0" + mes).slice(-2);

    var fechaInicial = año + "-" + mes + "-" + dia;
    var fechaFinal = año + "-" + mes + "-" + dia;

    localStorage.setItem("capturarRango", "Hoy");

    window.location = "index.php?ruta=pedidos&fechaInicial=" + fechaInicial + "&fechaFinal=" + fechaFinal;

  }

})

/*=============================================
ABRIR ARCHIVO XML EN NUEVA PESTAÑA
=============================================*/

$(".abrirXML").click(function () {

  var archivo = $(this).attr("archivo");
  window.open(archivo, "_blank");


})


