<?php

$item = "id";
$valor = Conexion::decryption($_GET["idPedido"]);

$pedido = ControladorPedidos::ctrMostrarPedidos($item, $valor);

if (!$pedido) {
  echo '<script>

  Swal.fire({
    title: "Error al cargar pedido",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Seleccionar"
  }).then(function(result){
    if (result.value) {

    window.location = "pedidos";

    }else{
      window.location = "inicio";
    }
  })
        </script>';
  exit();
}

$itemUsuario = "id";
$valorUsuario = $pedido["id_vendedor"];

$vendedor = ControladorUsuarios::ctrMostrarUsuarios($itemUsuario, $valorUsuario);

$itemCliente = "id";
$valorCoordinador = $pedido["id_coordinador"];

$coordinador = ControladorCoordinadores::ctrMostrarCoordinadores($itemCliente, $valorCoordinador);

?>

<style>
  input[type="number"] {
    padding: 10px !important;
    border: 1px solid #ccc !important;
    border-radius: 5px !important;
    font-size: 16px !important;
  }
</style>

<style>
  /* Estilos para dispositivos móviles */
  @media (max-width: 480px) {
    .form-group {
      font-size: 16px !important;
      margin-bottom: 10px !important;
    }

    .input-group {
      font-size: 16px !important;
    }
  }
</style>

<script>
  function validarEntero(input) {
    input.value = input.value.replace(/[^\d]/g, '');
  }
</script>

<div class="content-wrapper">

  <section class="content-header">
    <h1>
      Editar Pedido <strong><?php echo "#" . $pedido["id"]; ?></strong> Coordinador: <strong><?php echo $coordinador["nombre"]; ?></strong>
      </strong>Fecha Entrega: <strong><?php echo date("d/m/Y", strtotime($coordinador["fecha_entrega"])); ?></strong>
    </h1>
  </section>

  <section class="content">

    <form role="form" method="post" class="formularioVenta">

      <div class="box box-success">

        <div class="box-header with-border"></div>

        <div class="box-body">

          <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
              <div class="form-group">
                <div class="input-group">
                  <span class="input-group-addon"><i class="fa fa-id-card"></i></span>
                  <input type="text" placeholder="Nombre PAX" value="<?php echo $pedido["nombre_pax"]; ?>" name="nombrePax" class="form-control input-lg" style="border-radius: 5px;" required>
                </div>
              </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
              <div class="form-group">
                <div class="input-group">
                  <span class="input-group-addon"><i class="fa fa-id-card"></i></span>
                  <input type="text" inputmode="numeric" placeholder="Nro. de Habitación" value="<?php echo $pedido["nro_habitacion"]; ?>" name="nroHabitacion" class="form-control input-lg" style="border-radius: 5px;" required>
                </div>
              </div>
            </div>
          </div>

        </div>



      </div>



      <div class="row">
        <!-- TABLA DE PRODUCTOS -->
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <?php include('tabla-producto.php'); ?>
        </div>
      </div>
  </section>

  <section class="content">
    <div class="row">
      <div class="col-lg-12 col-xs-12 col-md-12">
        <div class="box box-success">

          <div class="box-header with-border"></div>



          <div class="box-body">

            <h4>Productos seleccionados</h4>

            <div class="box-header with-border"></div>

            <div class="form-group row nuevoProducto">

              <?php

              $listaProducto = json_decode($pedido["productos"], true);

              foreach ($listaProducto as $key => $value) {

                $item = "id";
                $valor = $value["id"];
                $orden = "id";

                $respuesta = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);

                $stockAntiguo = $respuesta["stock"] + $value["cantidad"];

                echo '<div class="row" style="padding:5px 15px">

                        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
            
                          <div class="input-group">
                
                            <span class="input-group-addon"><button type="button" class="btn btn-danger btn-md quitarProducto" idProducto="' . $value["id"] . '"><i class="fa fa-times"></i></button></span>

                            <input type="text" class="form-control nuevaDescripcionProducto input-lg" idProducto="' . $value["id"] . '" name="agregarProducto" value="' . $value["descripcion"] . '" style="border-radius: 5px !important;" readonly required>

                          </div>

                        </div>

                        <div class="col-lg-2 col-md-2 col-sm-2 col-xs-6">
              
                          <input type="number" inputmode="numeric" class="form-control nuevaCantidadProducto input-lg" name="nuevaCantidadProducto" min="1" value="' . $value["cantidad"] . '" stock="' . $stockAntiguo . '" nuevoStock="' . $value["stock"] . '" style="border-radius: 5px !important;" required>

                        </div>

                        <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6 ingresoPrecio">

                          <div class="input-group">

                            <span class="input-group-addon"><i class="ion ion-social-usd"></i></span>
                  
                            <input type="text" class="form-control nuevoPrecioProducto input-lg" precioReal="' . $respuesta["precio_venta"] . '" name="nuevoPrecioProducto" value="' . $value["total"] . '" style="border-radius: 5px !important;" readonly required>

                          </div>
              
                        </div>';

                if ($_SESSION["perfil"] == "Administrador" || $_SESSION["perfil"] == "Cajero") {
                  echo '
                          <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6 ingresoDescuento">

                            <div class="input-group">

                              <span class="input-group-addon"><i class="fa fa-percent" aria-hidden="true"></i></span>
                    
                              <input type="number" inputmode="numeric" class="form-control descuentoPorProducto input-lg" descuentoPorProducto="' . $value["descuento"] . '" name="descuentoPorProducto" value="' . $value["descuento"] . '" style="border-radius: 5px !important;">

                            </div>
              
                          </div>

                      </div><hr>';
                } else {
                  echo '</div>';
                }
              }


              ?>

            </div>

            <div class="form-group">
              <div class="row">
                <div class="col-lg-6 col-md-6 col-xs-12 col-sm-6">
                  <label for="validationDefault01">Total pedido</label>
                  <div class="input-group">
                    <span class="input-group-addon"><i class="ion ion-social-usd"></i></span>
                    <input type="text" class="form-control input-lg" id="nuevoTotalVenta" value="<?php echo $pedido["importe_total"]; ?>" name="nuevoTotalVenta" total="<?php echo $pedido["importe_neto"]; ?>" placeholder="00000" readonly required>
                  </div>
                </div>

                <div class="col-lg-6 col-md-6 col-xs-12 col-sm-6">

                  <div class="row">
                    <div class="col-lg-6">
                      <label for="validationDefault01">Descuento al total</label>
                      <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-percent"></i></span>
                        <input type="number" inputmode="numeric" style="border-radius: 5px !important;" class="form-control input-lg" min="0" id="nuevoDescuento" name="nuevoDescuento" value="<?php echo $pedido["descuento"]; ?>" placeholder="0" required>
                      </div>
                    </div>

                    <div class="col-lg-6">
                      <label for="validationDefault01">Pago</label>
                      <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-percent"></i></span>
                        <input type="number" inputmode="numeric" style="border-radius: 5px !important;" class="form-control input-lg" min="0" id="nuevoTotalPago" name="nuevoTotalPago" value="<?php echo $pedido["importe_pago"]; ?>" placeholder="0" required>
                      </div>
                    </div>
                  </div>


                </div>
              </div>
              <br>

            </div>

            <input type="hidden" id="listaProductos" name="listaProductos">
            <input type="hidden" class="form-control" id="nuevoPedido" name="editarPedido" value="<?php echo $pedido["id"]; ?>" readonly>
            <input type="hidden" name="nuevoPrecioNeto" id="nuevoPrecioNeto" value="<?php echo $pedido["importe_neto"]; ?>" required>
            <input type="hidden" name="totalVenta" value="<?php echo $pedido["importe_total"]; ?>" id="totalVenta">

            <br>

          </div>
          <div class="box-footer">

            <a href="pedidos" class="btn btn-default btn-lg">
              <i class="fa fa-arrow-circle-left" style="font-size:48px;color:black"></i> Atrás
            </a>

            <button type="submit" name="guardarPedido" class="btn btn-primary pull-right" style="font-size: 25px;">Guardar cambios</button>

            <?php if ($_SESSION["perfil"] == "Administrador" || $_SESSION["perfil"] == "Cajero") { ?>
              <button class="btn btn-success pull-right" type="submit" name="cobrarPedido" style="margin-right: 5px;font-size: 25px;">$ COBRAR</button>
            <?php } ?>



          </div>

          </form>
        </div>

        <?php

        $editarVenta = new ControladorPedidos();
        $editarVenta->ctrEditarPedido();
        $editarVenta->ctrCobrarPedido();

        ?>

      </div>
    </div>
</div>
</section>
</div>

<!--=====================================
MODAL AGREGAR CLIENTE
======================================-->

<div id="modalAgregarCoordinador" class="modal fade" role="dialog">

  <div class="modal-dialog">

    <div class="modal-content">

      <form role="form" method="post">

        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->

        <div class="modal-header" style="background:#FF2A13; color:white">

          <button type="button" class="close" data-dismiss="modal">&times;</button>

          <h4 class="modal-title">Agregar cliente</h4>

        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->

        <div class="modal-body">

          <div class="box-body">

            <!-- ENTRADA PARA EL NOMBRE -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-user"></i></span>

                <input type="text" class="form-control input-lg" name="nuevoCliente" placeholder="Ingresar nombre" required>

              </div>

            </div>

            <!-- ENTRADA PARA EL DOCUMENTO ID -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-key"></i></span>

                <input type="number" min="0" class="form-control input-lg" name="nuevoDocumentoId" placeholder="Ingresar documento" required>

              </div>

            </div>

            <!-- ENTRADA PARA EL EMAIL -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-envelope"></i></span>

                <input type="email" class="form-control input-lg" name="nuevoEmail" placeholder="Ingresar email" required>

              </div>

            </div>

            <!-- ENTRADA PARA EL TELÉFONO -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-phone"></i></span>

                <input type="text" class="form-control input-lg" name="nuevoTelefono" placeholder="Ingresar teléfono" data-inputmask="'mask':'(999) 999-9999'" data-mask required>

              </div>

            </div>

            <!-- ENTRADA PARA LA DIRECCIÓN -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-map-marker"></i></span>

                <input type="text" class="form-control input-lg" name="nuevaDireccion" placeholder="Ingresar dirección" required>

              </div>

            </div>

            <!-- ENTRADA PARA LA FECHA DE NACIMIENTO -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>

                <input type="text" class="form-control input-lg" name="nuevaFechaNacimiento" placeholder="Ingresar fecha nacimiento" data-inputmask="'alias': 'yyyy/mm/dd'" data-mask required>

              </div>

            </div>

          </div>

        </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->

        <div class="modal-footer">

          <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Salir</button>

          <button type="submit" class="btn btn-primary">Guardar cliente</button>

        </div>

      </form>

      <?php

      $crearCliente = new ControladorCoordinadores();
      $crearCliente->ctrCrearCoordinador();

      ?>

    </div>

  </div>

</div>