<?php

$item = "id";
$valor = Conexion::decryption($_GET["idPedido"]);

// Consultar si el pedido está siendo editado
$pedido = ControladorPedidos::ctrMostrarPedidos($item, $valor);

// Consultar si el pedido tiene el grupo ya cerrado
$grupoCerrado = ControladorCoordinadores::ctrMostrarCoordinadores("id", $pedido["id_coordinador"]);

if(intval($grupoCerrado["cerrado"] == 1)){
  echo '<script>
  Swal.fire({
    title: "El Grupo está cerrado, no es posible editar este pedido",
    icon: "info",
    timer: 2000,
    timerProgressBar: true,
    allowOutsideClick: false,
    showConfirmButton: false
  }).then(function() {
    window.location = "pedidos";
  });
  </script>  
  ';
  exit();
}


// Pago en hotel
$checked = ($pedido["pago_en_hotel"] != null) ? 'checked' : '';

if(intval($pedido["anulado"] == 1)){
  echo '<script>
  Swal.fire({
    title: "El pedido está anulado",
    icon: "info",
    timer: 2000,
    timerProgressBar: true,
    allowOutsideClick: false,
    showConfirmButton: false
  }).then(function() {
    window.location = "pedidos";
  });
  </script>  
  ';
  exit();
}

// Controlar cómo viene el campo que guarda la info de validación
$controlPedido = ($pedido["editando"] != null) ? $pedido["editando"] : null;

// Genero una especie de token, que es la combiacion del usuario + el id pedido
$token = $_SESSION["usuario"] . $pedido["id"];

if ($controlPedido == null && $_SESSION["perfil"] != "Vendedor") {
  ControladorPedidos::ctrEditandoPedido($valor, $token);
  $pedido = ControladorPedidos::ctrMostrarPedidos($item, $valor);
  $controlPedido = $pedido["editando"];
}

if ($controlPedido != $token && $_SESSION["perfil"] != "Vendedor") {
  echo '<script>
  Swal.fire({
    title: "El pedido está siendo editado por otro usuario",
    icon: "info",
    timer: 2000,
    timerProgressBar: true,
    allowOutsideClick: false,
    showConfirmButton: false
  }).then(function() {
    window.location = "pedidos";
  });
  </script>  
  ';
  exit();
} else {
  //echo "<script>toastr.info('Confirme el cobro una vez guardado los descuentos y cantidades.')</script>";
}

if (!$pedido) {
  echo '<script>

  Swal.fire({
    title: "Error al cargar pedido",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Seleccionar"
  }).then(function(result){
    if (result.value) {

    window.location = "pedidos";

    }else{
      window.location = "inicio";
    }
  })
        </script>';
  exit();
}

$itemUsuario = "id";
$valorUsuario = $pedido["id_vendedor"];

$vendedor = ControladorUsuarios::ctrMostrarUsuarios($itemUsuario, $valorUsuario);

$itemCliente = "id";
$valorCoordinador = $pedido["id_coordinador"];

$coordinador = ControladorCoordinadores::ctrMostrarCoordinadores($itemCliente, $valorCoordinador);

if (isset($_GET["estado"]) && $_GET["estado"] == "MODIFICADO") {
  echo '<script>
  toastr.options = {
    "closeButton": true,
    "debug": true,
    "newestOnTop": false,
    "progressBar": true,
    "positionClass": "toast-top-right",
    "preventDuplicates": true,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "3000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
  }
  // Display a success toast, with a title
  toastr["success"]("Pedido editado correctamente.", "Listo!");
</script>';
}

?>

<style>
  input[type="number"] {
    padding: 10px !important;
    border: 1px solid #ccc !important;
    border-radius: 5px !important;
    font-size: 16px !important;
  }
</style>

<style>
  /* Estilo personalizado para el checkbox */
  .custom-checkbox {
    display: inline-block;
    position: relative;
    padding-left: 30px;
    /* Espacio para el checkbox */
    cursor: pointer;
  }

  .custom-checkbox input {
    position: absolute;
    opacity: 0;
    cursor: pointer;
  }

  .checkmark {
    position: absolute;
    top: 0;
    left: 0;
    height: 25px;
    /* Altura del checkbox personalizado */
    width: 25px;
    /* Ancho del checkbox personalizado */
    background-color: #ccc;
  }

  .custom-checkbox input:checked+.checkmark {
    background-color: #2196F3;
    /* Cambia el color cuando está seleccionado */
  }

  .checkmark:after {
    content: "";
    position: absolute;
    display: none;
  }

  .custom-checkbox input:checked+.checkmark:after {
    display: block;
  }

  .custom-checkbox .checkmark:after {
    left: 9px;
    top: 5px;
    width: 5px;
    height: 10px;
    border: solid white;
    border-width: 0 3px 3px 0;
    transform: rotate(45deg);
  }
</style>

<style>
  /* Estilos para dispositivos móviles */
  @media (max-width: 480px) {
    .form-group {
      font-size: 16px !important;
      margin-bottom: 10px !important;
    }

    .input-group {
      font-size: 16px !important;
    }
  }
</style>

<script>
  function validarEntero(input) {
    input.value = input.value.replace(/[^\d]/g, '');
  }
</script>

<div class="content-wrapper">

  <section class="content-header">
    <h1>
      Editar Pedido NRO:<strong><?php echo $pedido["nro_pedido"]; ?> </strong> Empresa: <strong><?php echo $coordinador["empresa"]; ?></strong></strong> Coordinador: <strong><?php echo $coordinador["nombre"]; ?></strong>
      </strong><!--Fecha Entrega: <strong><?php echo date("d/m/Y", strtotime($coordinador["fecha_entrega"])); ?></strong>-->
    </h1>
  </section>

  <section class="content">

    <form role="form" method="post" class="formularioVenta">

      <div class="box box-success">

        <div class="box-header with-border"></div>

        <div class="box-body">

          <div class="row">
            <div class="col-lg-6 col-md-6 col-xs-6">
              <div class="form-group">
                <div class="input-group">
                  <span class="input-group-addon"><i class="fa fa-id-card"></i></span>
                  <input type="text" id="nombrePax" placeholder="Nombre PAX" value="<?php echo $pedido["nombre_pax"]; ?>" name="nombrePax" class="form-control" style="border-radius: 5px;">
                </div>
              </div>
            </div>
            <div class="col-lg-6 col-md-6 col-xs-6">
              <div class="form-group">
                <div class="input-group">
                  <span class="input-group-addon"><i class="fa fa-id-card"></i></span>
                  <input type="number" inputmode="numeric" id="nroHabitacion" placeholder="Nro. de Habitación" value="<?php echo $pedido["nro_habitacion"]; ?>" name="nroHabitacion" class="form-control" style="border-radius: 5px;">
                </div>
              </div>
              <label class="custom-checkbox">
                <input type="checkbox" name="pagoEnHotel" value=1 id="pagoEnHotel" <?php echo $checked; ?>>
                <span class="checkmark"></span>
                Pago en Hotel
            </div>
          </div>
        </div>

      </div>

      <?php

      if ($_SESSION["perfil"] == "Administrador" || $_SESSION["perfil"] == "Cajero") {
        $habilitar = '';
      } else {
        $habilitar = ' style="display:none;"';
      }

      ?>

      <div class="row">
        <!-- TABLA DE PRODUCTOS -->
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
          <?php include('tabla-producto.php'); ?>
        </div>
      </div>

      <div class="row">
        <div class="col-lg-12 col-xs-12 col-md-12">
          <div class="box box-success">

            <div class="box-header with-border"></div>

            <div class="box-body">

              <h4>Productos seleccionados</h4>

              <div class="box-header with-border"></div>

              <div class="form-group row nuevoProducto">

                <?php

                $listaProducto = json_decode($pedido["productos"], true);

                foreach ($listaProducto as $key => $value) {

                  $item = "id";
                  $valor = $value["id"];
                  $orden = "id";

                  $respuesta = ControladorProductos::ctrMostrarProductos($item, $valor, $orden, true);

                  $stockAntiguo = $respuesta["stock"] + $value["cantidad"];

                  echo '<div class="row" style="padding:5px 15px">
  
                        <div class="col-lg-5 col-md-5 col-sm-6 col-xs-6">
              
                            <div class="input-group">
                  
                              <span class="input-group-addon"><button type="button" class="btn btn-danger btn-xs quitarProducto" idProducto="' . $value["id"] . '"><i class="fa fa-times"></i></button></span>

                              <input type="text" class="form-control nuevaDescripcionProducto" idProducto="' . $value["id"] . '" name="agregarProducto" value="' . $value["descripcion"] . '" style="border-radius: 5px !important;" readonly required>

                            </div>

                          </div>

                          <div class="col-lg-2 col-md-3 col-sm-3 col-xs-3">
                            <div class="input-group">
                              <input type="number" inputmode="numeric" class="form-control nuevaCantidadProducto" name="nuevaCantidadProducto" min="1" value="' . $value["cantidad"] . '" stock="' . $stockAntiguo . '" nuevoStock="' . $value["stock"] . '" style="border-radius: 5px !important;" required disabled>
                              <div class="input-group-btn">
                                <button class="btn btn-default decrementButton" value="' . $value["cantidad"] . '" type="button"><i class="fa fa-minus" aria-hidden="true"></i></button>
                                <button class="btn btn-default incrementButton" value="' . $value["cantidad"] . '" type="button"><i class="fa fa-plus" aria-hidden="true"></i></button>
                              </div>
                            </div>
                          </div>

                          <div class="col-lg-3 col-md-2 col-sm-3 col-xs-3 ingresoPrecio">

                            <div class="input-group">

                              <span class="input-group-addon"><i class="ion ion-social-usd"></i></span>
                    
                              <input type="text" class="form-control nuevoPrecioProducto" precioReal="' . $respuesta["precio_venta"] . '" name="nuevoPrecioProducto" value="' . $value["total"] . '" style="border-radius: 5px !important;" readonly required>

                            </div>
                
                          </div>';

                  if ($_SESSION["perfil"] == "Administrador" || $_SESSION["perfil"] == "Cajero") {
                    echo '
                    <div class="col-lg-2 col-md-2 col-xs-6 ingresoDescuento">

                              <div class="input-group">

                                <span class="input-group-addon"><i class="fa fa-percent" aria-hidden="true"></i></span>
                      
                                <input type="number" inputmode="numeric" class="form-control descuentoPorProducto" min="0" placeholder="% descuento individual" descuentoPorProducto="' . $value["descuento"] . '" name="descuentoPorProducto" value="' . $value["descuento"] . '" style="border-radius: 5px !important;">

                              </div>
                
                            </div>

                        </div>';
                  } else {
                    echo '</div>';
                  }
                }


                ?>

              </div>

              <div class="form-group">
                <div class="row">
                  <div class="col-lg-6 col-md-6 col-xs-12 col-sm-6">

                    <div class="row">
                      <div class="col-lg-6">

                        <label for="validationDefault01">Total pedido</label>
                        <div class="input-group">
                          <span class="input-group-addon"><i class="ion ion-social-usd"></i></span>
                          <input type="text" class="form-control input-lg" id="nuevoTotalVenta" value="<?php echo $pedido["importe_total"]; ?>" name="nuevoTotalVenta" total="<?php echo $pedido["importe_neto"]; ?>" placeholder="00000" readonly required style="border-radius:5px;">
                        </div>

                      </div>
                      <div class="col-lg-6" <?php echo $habilitar; ?>>
                        <label for="validationDefault01">Pago</label>
                        <div class="input-group">
                          <span class="input-group-addon"><i class="fa fa-percent"></i></span>
                          <input type="text" inputmode="numeric" style="border-radius: 5px !important;" class="form-control input-lg nuevoTotalPago" min="0" id="nuevoTotalPago" name="nuevoTotalPago" value="<?php echo $pedido["importe_pago"]; ?>" placeholder="0" required>
                          <input type="hidden" id="nuevoTotalDebe" name="nuevoTotalDebe" value="<?php echo $pedido["importe_debe"]; ?>">
                        </div>
                      </div>
                    </div>


                  </div>



                  <div class="col-lg-3 col-md-6 col-xs-12 col-sm-6" <?php echo $habilitar; ?>>
                    <label for="validationDefault01">Descuento general</label>
                    <div class="input-group">
                      <span class="input-group-addon"><i class="fa fa-percent"></i></span>
                      <input type="number" inputmode="numeric" style="border-radius: 5px !important;" class="form-control input-lg" min="0" id="nuevoDescuento" name="nuevoDescuento" value="<?php echo $pedido["descuento"]; ?>" placeholder="% descuento general" autocomplete="off">
                    </div>
                  </div>
                </div>
                <br>

              </div>

              <input type="hidden" id="listaProductos" name="listaProductos">
              <input type="hidden" class="form-control" id="nuevoPedido" name="editarPedido" value="<?php echo $pedido["id"]; ?>" readonly>
              <input type="hidden" name="nuevoPrecioNeto" id="nuevoPrecioNeto" value="<?php echo $pedido["importe_neto"]; ?>" required>
              <input type="hidden" name="totalVenta" value="<?php echo $pedido["importe_total"]; ?>" id="totalVenta">

              <br>

            </div>
            <div class="box-footer">

              <a href="pedidos" class="btn btn-default btn-lg">
                <i class="fa fa-arrow-circle-left" style="font-size:48px;color:black"></i> Atrás
              </a>

              <?php if ($_SESSION["perfil"] == "Vendedor") { ?>

              
                <button type="submit" name="guardarPedido" id="guardarNuevoPedido" class="btn btn-primary pull-right" style="font-size: 25px;">Guardar cambios</button>
              
              <?php } ?>

              <!--<button type="submit" name="guardarPedido" id="guardarNuevoPedido" class="btn btn-primary pull-right" style="font-size: 25px;">Guardar cambios</button>-->

              <?php if ($_SESSION["perfil"] == "Administrador" || $_SESSION["perfil"] == "Cajero") { ?>
                <!--<h4>Para asegurarse de cobrar correctamente, primero guarde los cambios. </h4>-->

                <button style="display: none;" class="btn btn-success pull-right" type="submit" name="cobrarPedido" style="margin-right: 5px; font-size: 25px;" onclick="return confirm('¿Confirma el cobro del Pedido por un importe de $<?php echo $pedido['importe_total']; ?>?');">$ COBRAR</button>

                <button class="btn btn-success pull-right" type="submit" name="editarCobrarPedido" style="margin-right: 5px; font-size: 25px;" onclick="return confirmarCobro()">$ COBRAR</button>

              <?php } ?>



            </div>

    </form>
</div>



</div>
</div>
</div>
</section>
</div>

<?php

$editarVenta = new ControladorPedidos();
$editarVenta->ctrEditarCobrarPedido();
$editarVenta->ctrEditarPedido();
$editarVenta->ctrCobrarPedido();

?>

<!--=====================================
MODAL AGREGAR CLIENTE
======================================-->

<div id="modalAgregarCoordinador" class="modal fade" role="dialog">

  <div class="modal-dialog">

    <div class="modal-content">

      <form role="form" method="post">

        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->

        <div class="modal-header" style="background:#FF2A13; color:white">

          <button type="button" class="close" data-dismiss="modal">&times;</button>

          <h4 class="modal-title">Agregar cliente</h4>

        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->

        <div class="modal-body">

          <div class="box-body">

            <!-- ENTRADA PARA EL NOMBRE -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-user"></i></span>

                <input type="text" class="form-control input-lg" name="nuevoCliente" placeholder="Ingresar nombre" required>

              </div>

            </div>

            <!-- ENTRADA PARA EL DOCUMENTO ID -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-key"></i></span>

                <input type="number" min="0" class="form-control input-lg" name="nuevoDocumentoId" placeholder="Ingresar documento" required>

              </div>

            </div>

            <!-- ENTRADA PARA EL EMAIL -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-envelope"></i></span>

                <input type="email" class="form-control input-lg" name="nuevoEmail" placeholder="Ingresar email" required>

              </div>

            </div>

            <!-- ENTRADA PARA EL TELÉFONO -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-phone"></i></span>

                <input type="text" class="form-control input-lg" name="nuevoTelefono" placeholder="Ingresar teléfono" data-inputmask="'mask':'(999) 999-9999'" data-mask required>

              </div>

            </div>

            <!-- ENTRADA PARA LA DIRECCIÓN -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-map-marker"></i></span>

                <input type="text" class="form-control input-lg" name="nuevaDireccion" placeholder="Ingresar dirección" required>

              </div>

            </div>

            <!-- ENTRADA PARA LA FECHA DE NACIMIENTO -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>

                <input type="text" class="form-control input-lg" name="nuevaFechaNacimiento" placeholder="Ingresar fecha nacimiento" data-inputmask="'alias': 'yyyy/mm/dd'" data-mask required>

              </div>

            </div>

          </div>

        </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->

        <div class="modal-footer">

          <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Salir</button>

          <button type="submit" class="btn btn-primary">Guardar cliente</button>

        </div>

      </form>

      <?php

      $crearCliente = new ControladorCoordinadores();
      $crearCliente->ctrCrearCoordinador();

      ?>

    </div>

  </div>

</div>

<script>
  $(document).ready(function() {
    // Si el pedido se paga en hotel, bloquear boton de ingreso de monto pago

    var totalDebe = $('#nuevoTotalDebe').val();

    $('#pagoEnHotel').change(function() {
      if (this.checked) {
        // El checkbox está seleccionado
        $('.nuevoTotalPago').attr('disabled', true);
      } else {
        // El checkbox no está seleccionado
        $('.nuevoTotalPago').attr('disabled', false);
        $('.nuevoTotalPago').val(totalDebe);

      }
    });

  });
</script>

<!-- Coloca este script antes del botón o en el encabezado del HTML -->
<script>
  function confirmarCobro() {
    var totalVenta = parseFloat($('#totalVenta').val());
    var formattedTotal = formatCurrency(totalVenta);
    return confirm('¿Confirma el cobro del Pedido por un importe de ' + formattedTotal + '?');
  }

  function formatCurrency(amount) {
    return '$' + amount.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
  }
</script>