<?php
$fecha = date("d M Y");
$vendedor = 0;
$cajero = 0;
if ($_SESSION["perfil"] == "Vendedor") {
  $vendedor = true;
}

if ($_SESSION["perfil"] == "Cajero") {
  $cajero = true;
}

if (isset($_GET["modificado"]) && $_GET["modificado"] == "MODIFICADO") {
  echo '<script>
  toastr.options = {
    "closeButton": true,
    "debug": true,
    "newestOnTop": false,
    "progressBar": true,
    "positionClass": "toast-top-right",
    "preventDuplicates": true,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "3000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
  }
  // Display a success toast, with a title
  toastr["success"]("Pedido editado correctamente.", "Listo!");
</script>';
}

if (isset($_GET["cobrado"]) && $_GET["cobrado"] == "COBRADO") {
  echo '<script>
  toastr.options = {
    "closeButton": true,
    "debug": true,
    "newestOnTop": false,
    "progressBar": true,
    "positionClass": "toast-top-right",
    "preventDuplicates": true,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "3000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
  }
  // Display a success toast, with a title
  toastr["success"]("Pedido cobrado correctamente.", "Listo!");
</script>';
}

if (isset($_GET["status"]) && $_GET["status"] == 1) {
  echo '<script>
  toastr.options = {
    "closeButton": true,
    "debug": true,
    "newestOnTop": false,
    "progressBar": true,
    "positionClass": "toast-top-right",
    "preventDuplicates": true,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "3000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
  }
  // Display a success toast, with a title
  toastr["success"]("Pedido editado correctamente.", "Listo!");
</script>';
}
if (isset($_GET["status"]) && $_GET["status"] != 1) {
  echo '<script>
  toastr.options = {
    "closeButton": true,
    "debug": true,
    "newestOnTop": false,
    "progressBar": true,
    "positionClass": "toast-top-right",
    "preventDuplicates": true,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "5000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
  }
  // Display a success toast, with a title
  toastr["error"]("Error al guardar el pedido!", "Error!");
</script>';
}

?>

<style>
  @media (max-width: 767px) {
  /* Ocultar los botones en dispositivos con ancho menor o igual a 767px (modo celular) */
  .btnImprimirNotaPedidoIndividual,
  .btnImprimirExcel {
    display: none;
  }
}

@media (min-width: 768px) and (max-width: 991px) {
  /* Ocultar los botones en dispositivos con ancho entre 768px y 991px (modo tablet) */
  .btnImprimirNotaPedidoIndividual,
  .btnImprimirExcel {
    display: none;
  }
}

@media (min-width: 1340) and (max-width: 800px) {
  /* Ocultar los botones en dispositivos con ancho entre 768px y 991px (modo tablet) */
  .btnImprimirNotaPedidoIndividual,
  .btnImprimirExcel {
    display: none;
  }
}

</style>

<div class="content-wrapper">

  <section class="content-header">

    <h1>

    <?php if($_SESSION["perfil"] == "Administrador"){ ?>
      <?php if(!isset($_GET["fechaInicial"])){ ?>
        <li class="active">Historial de Pedidos</li>
      <?php } ?>        
      <?php } ?>

      <?php if(isset($_GET["fechaInicial"]) && isset($_GET["fechaFinal"])){ ?>
        <li class="active">Historial de pedidos desde el <strong><?php echo strftime("%d %b %Y", strtotime($_GET["fechaInicial"])) ?></strong> al <strong><?php echo strftime("%d %b %Y", strtotime($_GET["fechaFinal"])) ?></strong></li>
      <?php } ?>

    </h1>

    <ol class="breadcrumb">

      <li><a href="inicio"><i class="fa fa-dashboard"></i> Inicio</a></li>

      <?php if($_SESSION["perfil"] == "Administrador"){ ?>
        <li class="active">Historial de pedidos</li>
      <?php } ?>

    </ol>

  </section>

  <section class="content">

    <div class="box">

      <div class="box-header with-border">

        <button type="button" class="btn btn-default pull-right" id="daterange-btn-historial-pedidos">

            <span>
              <i class="fa fa-calendar"></i> Rango de fecha
            </span>

            <i class="fa fa-caret-down"></i>

         </button>

        <button type="button" class="btn btn-default pull-right" id="daterange-btn-historial-pedidos" style="display:none;">

          <span>
            <i class="fa fa-calendar"></i>

            <?php

            if (isset($_GET["fechaInicial"])) {

              echo $_GET["fechaInicial"] . " - " . $_GET["fechaFinal"];
            } else {

              echo 'Rango de fecha';
            }

            ?>
          </span>

          <i class="fa fa-caret-down"></i>

        </button>

      </div>

      <div class="box-body">

        <table class="table table-bordered table-striped dt-responsive tablasHistorialPedidos hover" cellspacing="0" width="100%">

          <thead>

            <tr>

              <th>Nro.</th>
              <th>Fecha</th>
              <th>Empresa</th>
              <th>Coordinador</th>      
              <th>PAX</th>    
              <th>Total</th>
              <?php if($_SESSION["perfil"] != "Vendedor"){ ?>
              <th>Estado</th>
              <?php } ?>
              <?php if($_SESSION["perfil"] != "Vendedor"){ ?>
              <th>Cerrado</th>
              <th>Anulado</th>
              <?php } ?>
              <?php if($_SESSION["perfil"] != "Vendedor"){ ?>
              <th>Fecha Entrega</th>
              <?php } ?>
              <th style="text-align: right;">Acciones</th>

            </tr>

          </thead>

          <tbody>

            <?php

            if (isset($_GET["fechaInicial"])) {

              $fechaInicial = $_GET["fechaInicial"];
              $fechaFinal = $_GET["fechaFinal"];
            } else {

              $fechaInicial = null;
              $fechaFinal = null;
            }

            $usuario = $_SESSION["id"];

            $respuesta = ControladorPedidos::ctrHistorialPedidos($fechaInicial, $fechaFinal);
            // Convertir el objeto en JSON
            $json = json_encode($respuesta);

            // Imprimir el JSON
            //echo $json;
            $cobrado = '';
            foreach ($respuesta as $key => $value) {

              $cerrado = $value["cerrado"] != null ? 'Cerrado' : '';
              $anulado = $value["anulado"] != null ? 'Anulado' : '';

              $item = 'id';
              $dataCoordinador = ControladorCoordinadores::ctrMostrarCoordinadores($item, $value["id_coordinador"]);
              
              $color = 'background-color:'.$dataCoordinador["color"].';';
              $idPedido = Conexion::encryption($value["id"]);
              echo '<tr>

                  <td style="'.$color.'"><strong>' . $value["nro_pedido"] . '</strong></td>';

              $itemCliente = "id";
              $valorCliente = $value["id_coordinador"];

              $respuestaCoordinador = ControladorCoordinadores::ctrMostrarCoordinadores($itemCliente, $valorCliente);

              echo '<td style="'.$color.'" class="btnVerPedido" idPedido="' . $idPedido . '">' . $value["fecha"] . '</td>';

              echo '<td style="'.$color.'" class="btnVerPedido" idPedido="' . $idPedido . '">' . $respuestaCoordinador["empresa"] . '</td>';

              echo '<td style="'.$color.'" class="btnVerPedido" idPedido="' . $idPedido . '">' . $respuestaCoordinador["nombre"] . '</td>';

              echo '<td style="'.$color.'" class="btnVerPedido" idPedido="' . $idPedido . '">' . $value["nombre_pax"].' Hab:.'.$value["nro_habitacion"]. '</td>';

              $itemUsuario = "id";
              $valorUsuario = $value["id_vendedor"];

              $respuestaUsuario = ControladorUsuarios::ctrMostrarUsuarios($itemUsuario, $valorUsuario);

              if ($value["estado"] == "IMPAGO") {
                $disabled = "";
              } else {
                $disabled = "disabled";
              }

              echo '
                  
                  <td style="'.$color.'">$ ' . number_format($value["importe_total"], 2) . '</td>';

                  if($_SESSION["perfil"] != "Vendedor"){
                    echo '<td style="'.$color.'">' . $value["estado"] . '</td>
                      <td style="'.$color.'">' . $cerrado . '</td>
                      <td style="'.$color.'">' . $anulado . '</td>
                     <td style="'.$color.'">' . strftime("%d %b %Y", strtotime($dataCoordinador["fecha_entrega"])). '</td>';
                  }

                  echo '

                  <td style="text-align: right;">
                <div class="btn-group">
                    <button class="btn btn-info btnVerPedido" IdPedido="' . $idPedido . '">
                      <i class="fa fa-eye"></i>
                    </button>';
                    
                  echo '</div>
                    </td>


                </tr>';
            }

            ?>

          </tbody>

        </table>

      </div>

    </div>

  </section>

</div>

<div id="dataModal" class="modal fade">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Detalle Pedido</h4>
      </div>
      <div class="modal-body" id="detalles">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>